/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.posweb;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.payments.PaymentAction;
import nl.strohalm.cyclos.controls.posweb.PosWebHelper;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidUserForChannelException;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentService;
import nl.strohalm.cyclos.services.transactions.exceptions.AuthorizedPaymentInPastException;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class BasePosWebPaymentAction
extends PaymentAction {
    private static final Relationship[] TRANSFER_FETCH = new Relationship[]{Payment.Relationships.TYPE, RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER, Element.Relationships.USER), RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER, Element.Relationships.USER)};
    private static final Relationship[] SCHEDULED_FETCH = new Relationship[]{ScheduledPayment.Relationships.TRANSFERS, Payment.Relationships.TYPE, RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER, Element.Relationships.USER), RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER, Element.Relationships.USER)};
    protected PaymentCustomFieldService paymentCustomFieldService;
    protected ScheduledPaymentService scheduledPaymentService;
    private CustomFieldHelper customFieldHelper;

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setScheduledPaymentService(ScheduledPaymentService scheduledPaymentService) {
        this.scheduledPaymentService = scheduledPaymentService;
    }

    protected abstract Payment doPayment(ActionContext var1, DoPaymentDTO var2);

    @Override
    protected void formAction(ActionContext context) throws Exception {
        Payment payment;
        HttpSession session = context.getSession();
        try {
            this.permissionService.permission().member(new MemberPermission[0]).operator(this.getPermission()).check();
            payment = this.doPayment(context, this.resolvePaymentDTO(context));
            session.removeAttribute("payment");
        }
        catch (InvalidUserForChannelException e) {
            throw new ValidationException("posweb.error.channelDisabled", new Object[0]);
        }
        catch (NotEnoughCreditsException e) {
            throw new ValidationException("posweb.error.notEnoughCredits", this.actionHelper.resolveParameters(e));
        }
        catch (CreditsException e) {
            throw new ValidationException(this.actionHelper.resolveErrorKey(e), this.actionHelper.resolveParameters(e));
        }
        catch (UnexpectedEntityException e) {
            throw new ValidationException("payment.error.invalidTransferType", new Object[0]);
        }
        catch (AuthorizedPaymentInPastException e) {
            throw new ValidationException("payment.error.authorizedInPast", new Object[0]);
        }
        payment = payment instanceof Transfer ? this.paymentService.load(payment.getId(), TRANSFER_FETCH) : this.scheduledPaymentService.load(payment.getId(), SCHEDULED_FETCH);
        session.setAttribute("lastPayment", (Object)payment);
        session.setAttribute("lastPaymentIsScheduled", (Object)(payment instanceof ScheduledPayment));
        List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(payment.getType(), false);
        Collection<CustomFieldHelper.Entry> entries = this.customFieldHelper.buildEntries(customFields, payment.getCustomValues());
        session.setAttribute("lastPaymentCustomValues", entries);
    }

    @Override
    protected AccountOwner getFromOwner(ActionContext context) {
        return context.getAccountOwner();
    }

    protected abstract OperatorPermission getPermission();

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        if (!this.permissionService.permission().member(new MemberPermission[0]).operator(this.getPermission()).hasPermission()) {
            context.getSession().invalidate();
            throw new PermissionDeniedException();
        }
        HttpServletRequest request = context.getRequest();
        List<Currency> currencies = this.resolveCurrencies(context);
        request.setAttribute("currencies", currencies);
        if (CollectionUtils.isEmpty(currencies)) {
            throw new ValidationException("payment.error.noTransferType", new Object[0]);
        }
        if (currencies.size() == 1) {
            request.setAttribute("singleCurrency", (Object)currencies.iterator().next());
        }
        Member loggedMember = (Member)context.getAccountOwner();
        boolean showDescription = loggedMember.getMemberGroup().getMemberSettings().isShowPosWebPaymentDescription();
        request.setAttribute("loggedMember", (Object)loggedMember);
        request.setAttribute("showDescription", (Object)showDescription);
    }

    @Override
    protected ActionForward resolveLoginForward(ActionMapping actionMapping, HttpServletRequest request) {
        return new ActionForward(PosWebHelper.loginUrl(request), true);
    }

    @Override
    protected TransferTypeQuery resolveTransferTypeQuery(ActionContext context) {
        return null;
    }
}

