/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.posweb;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.access.LoginForm;
import nl.strohalm.cyclos.controls.posweb.PosWebHelper;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.OperatorUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.permissions.PermissionService;
import nl.strohalm.cyclos.services.preferences.ReceiptPrinterSettingsService;
import nl.strohalm.cyclos.utils.LoginHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LoginAction
extends nl.strohalm.cyclos.controls.access.LoginAction {
    private PermissionService permissionService;
    private ReceiptPrinterSettingsService receiptPrinterSettingsService;

    @Inject
    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Inject
    public void setReceiptPrinterSettingsService(ReceiptPrinterSettingsService receiptPrinterSettingsService) {
        this.receiptPrinterSettingsService = receiptPrinterSettingsService;
    }

    @Override
    protected ActionForward alreadyLoggedForward(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, LoginForm form, User user) {
        return this.loginForward(mapping, request, response, form, user);
    }

    @Override
    protected ActionForward doLogin(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, LoginForm form) {
        form.setPrincipalType(Channel.Principal.USER.name());
        HttpSession session = request.getSession();
        session.setAttribute("isPosWeb", (Object)true);
        session.setAttribute("isWebShop", (Object)false);
        ActionForward forward = super.doLogin(mapping, request, response, form);
        session = request.getSession();
        User loggedUser = LoginHelper.getLoggedUser(request);
        if (loggedUser != null) {
            boolean showTransactions;
            boolean showReceive;
            boolean showMake;
            if (loggedUser instanceof OperatorUser) {
                showMake = this.permissionService.hasPermission(OperatorPermission.PAYMENTS_POSWEB_MAKE_PAYMENT);
                showReceive = this.permissionService.hasPermission(OperatorPermission.PAYMENTS_POSWEB_RECEIVE_PAYMENT);
                showTransactions = this.permissionService.hasPermission(OperatorPermission.ACCOUNT_ACCOUNT_INFORMATION);
            } else {
                PosWebHelper.Action action = PosWebHelper.getAction(request);
                showMake = action.canPay();
                showReceive = action.canReceive();
                showTransactions = true;
            }
            session.setAttribute("showMake", (Object)showMake);
            session.setAttribute("showReceive", (Object)showReceive);
            session.setAttribute("showTransactions", (Object)showTransactions);
            boolean hasReceiptPrinters = CollectionUtils.isNotEmpty(this.receiptPrinterSettingsService.list());
            session.setAttribute("hasReceiptPrinters", (Object)hasReceiptPrinters);
        }
        return forward;
    }

    @Override
    protected ActionForward handleDisplay(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("isOperator", (Object)PosWebHelper.isOperator(request));
        return super.handleDisplay(mapping, actionForm, request, response);
    }

    @Override
    protected boolean isMemberRequired(HttpServletRequest request) {
        return PosWebHelper.isOperator(request);
    }

    @Override
    protected ActionForward loginForward(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, LoginForm form, User user) {
        boolean canReceive;
        boolean canPay;
        if (user instanceof MemberUser) {
            PosWebHelper.Action action = PosWebHelper.getAction(request);
            canPay = action.canPay();
            canReceive = action.canReceive();
            if (this.elementService.shallAcceptAgreement(((MemberUser)user).getMember())) {
                request.getSession().setAttribute("shallAcceptRegistrationAgreement", (Object)true);
                return mapping.findForward("poswebAcceptRegistrationAgreement");
            }
        } else {
            canPay = this.permissionService.hasPermission(OperatorPermission.PAYMENTS_POSWEB_MAKE_PAYMENT);
            canReceive = this.permissionService.hasPermission(OperatorPermission.PAYMENTS_POSWEB_RECEIVE_PAYMENT);
        }
        if (!canPay && !canReceive) {
            request.getSession().invalidate();
            throw new PermissionDeniedException();
        }
        if (this.accessService.hasPasswordExpired()) {
            request.getSession().setAttribute("expiredPassword", (Object)true);
            return mapping.findForward("poswebChangeExpiredPassword");
        }
        if (canReceive) {
            return mapping.findForward("receivePayment");
        }
        return mapping.findForward("makePayment");
    }

    @Override
    protected Class<? extends User> requiredUserType(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, LoginForm form) {
        if (PosWebHelper.isOperator(request)) {
            return OperatorUser.class;
        }
        return MemberUser.class;
    }

    @Override
    protected String resolveErrorReturnTo(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, LoginForm form) {
        return PosWebHelper.loginUrl(request);
    }
}

