/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.posweb;

import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.posweb.BasePosWebPaymentAction;
import nl.strohalm.cyclos.controls.posweb.MakePaymentForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;

public class MakePaymentAction
extends BasePosWebPaymentAction {
    @Override
    protected Transfer doPayment(ActionContext context, DoPaymentDTO dto) {
        MakePaymentForm form = (MakePaymentForm)((Object)context.getForm());
        try {
            if (this.shouldValidateTransactionPassword(context, dto)) {
                this.accessService.checkTransactionPassword(form.getTransactionPassword());
            }
        }
        catch (InvalidCredentialsException e) {
            throw new ValidationException("transactionPassword", "login.transactionPassword", new InvalidError());
        }
        catch (BlockedCredentialsException e) {
            throw new ValidationException(new ValidationError("transactionPassword.error.blockedByTrials", new Object[0]));
        }
        return (Transfer)this.getPaymentService().doPayment(dto);
    }

    @Override
    protected OperatorPermission getPermission() {
        return OperatorPermission.PAYMENTS_POSWEB_MAKE_PAYMENT;
    }

    @Override
    protected DoPaymentDTO resolvePaymentDTO(ActionContext context) {
        Member member = (Member)context.getAccountOwner();
        MakePaymentForm form = (MakePaymentForm)((Object)context.getForm());
        DoPaymentDTO payment = this.getDataBinder().readFromString((Object)form);
        payment.setChannel("web");
        payment.setContext(TransactionContext.PAYMENT);
        payment.setFrom(member);
        return payment;
    }

    @Override
    protected void validateForm(ActionContext context) {
        DoPaymentDTO dto = this.resolvePaymentDTO(context);
        this.getPaymentService().validate(dto);
        Object group = context.getGroup();
        if (group instanceof OperatorGroup) {
            group = this.groupService.load(((Entity)group).getId(), RelationshipHelper.nested(OperatorGroup.Relationships.MEMBER, Element.Relationships.GROUP));
        }
        this.validateTransactionPassword(context, dto);
    }

    private boolean shouldValidateTransactionPassword(ActionContext context, DoPaymentDTO payment) {
        TransferType transferType = this.transferTypeService.load(payment.getTransferType().getId(), TransferType.Relationships.FROM);
        if (transferType == null) {
            return context.isTransactionPasswordEnabled();
        }
        return context.isTransactionPasswordEnabled(transferType.getFrom());
    }

    private void validateTransactionPassword(ActionContext context, DoPaymentDTO dto) {
        if (this.shouldValidateTransactionPassword(context, dto)) {
            context.validateTransactionPassword();
            Validator validator = new Validator();
            validator.property("transactionPassword").required().key("login.transactionPassword");
            validator.validate(context.getForm());
        }
    }
}

