/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.posweb;

import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.utils.RequestHelper;

public class PosWebHelper {
    private static final String IS_OPERATOR_COOKIE = "posweb_is_operator";
    private static final String ACTION_COOKIE = "posweb_action";

    public static Action getAction(HttpServletRequest request) {
        Action action;
        try {
            action = (Action)((Object)request.getAttribute(ACTION_COOKIE));
            if (action != null) {
                return action;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            action = (Action)((Object)request.getSession().getAttribute(ACTION_COOKIE));
            if (action != null) {
                return action;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Cookie cookie = RequestHelper.getCookie((ServletRequest)request, ACTION_COOKIE);
            if (cookie != null) {
                return Action.valueOf(cookie.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Action.BOTH;
    }

    public static boolean isOperator(HttpServletRequest request) {
        Boolean attr;
        try {
            attr = (Boolean)request.getAttribute(IS_OPERATOR_COOKIE);
            if (attr != null) {
                return attr;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            HttpSession session = request.getSession();
            if (session != null && (attr = (Boolean)session.getAttribute(IS_OPERATOR_COOKIE)) != null) {
                return attr;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Cookie cookie = RequestHelper.getCookie((ServletRequest)request, IS_OPERATOR_COOKIE);
            if (cookie != null) {
                return Boolean.parseBoolean(cookie.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String loginUrl(HttpServletRequest request) {
        if (PosWebHelper.isOperator(request)) {
            return "/posweb/operator";
        }
        switch (PosWebHelper.getAction(request)) {
            case PAY: {
                return "/posweb/pay";
            }
            case RECEIVE: {
                return "/posweb/receive";
            }
        }
        return "/posweb";
    }

    public static void setAction(HttpServletRequest request, HttpServletResponse response, Action action) {
        request.setAttribute(ACTION_COOKIE, (Object)action);
        request.getSession().setAttribute(ACTION_COOKIE, (Object)action);
        response.addCookie(new Cookie(ACTION_COOKIE, action.name()));
    }

    public static void setOperator(HttpServletRequest request, HttpServletResponse response, boolean isOperator) {
        request.setAttribute(IS_OPERATOR_COOKIE, (Object)isOperator);
        request.getSession().setAttribute(IS_OPERATOR_COOKIE, (Object)isOperator);
        response.addCookie(new Cookie(IS_OPERATOR_COOKIE, String.valueOf(isOperator)));
    }

    public static enum Action {
        BOTH,
        PAY,
        RECEIVE;


        public boolean canPay() {
            return this == BOTH || this == PAY;
        }

        public boolean canReceive() {
            return this == BOTH || this == RECEIVE;
        }
    }
}

