/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.posweb;

import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.posweb.SearchTransactionsAction;
import nl.strohalm.cyclos.controls.posweb.SearchTransactionsForm;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentService;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import org.apache.struts.action.ActionForward;

public class PrintTransactionsAction
extends BaseAction {
    private PaymentService paymentService;
    private ScheduledPaymentService scheduledPaymentService;

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public void setScheduledPaymentService(ScheduledPaymentService scheduledPaymentService) {
        this.scheduledPaymentService = scheduledPaymentService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        SearchTransactionsForm form = (SearchTransactionsForm)((Object)context.getForm());
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        CalendarConverter rawDateConverter = localSettings.getRawDateConverter();
        Calendar date = rawDateConverter.valueOf(form.getDate());
        if (date == null) {
            date = Calendar.getInstance();
        }
        Member owner = context.getMember();
        HttpServletRequest request = context.getRequest();
        request.setAttribute("date", (Object)date);
        request.setAttribute("owner", (Object)owner);
        List<SearchTransactionsAction.Entry> transfers = SearchTransactionsAction.listTransfers(this.paymentService, owner, date);
        request.setAttribute("transfers", transfers);
        List<SearchTransactionsAction.Entry> scheduledPayments = SearchTransactionsAction.listScheduledPayments(this.scheduledPaymentService, owner, date);
        request.setAttribute("scheduledPayments", scheduledPayments);
        return context.getInputForward();
    }
}

