/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.posweb;

import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.payments.SchedulingType;
import nl.strohalm.cyclos.controls.posweb.BasePosWebPaymentAction;
import nl.strohalm.cyclos.controls.posweb.ReceivePaymentForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCardException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidUserForChannelException;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentDTO;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PositiveNonZeroValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.TodayValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;

public class ReceivePaymentAction
extends BasePosWebPaymentAction {
    private ChannelService channelService;

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Override
    protected Payment doPayment(final ActionContext context, final DoPaymentDTO dto) {
        Member from;
        try {
            from = (Member)this.elementService.load(((Member)dto.getFrom()).getId(), Element.Relationships.USER);
            if (from == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        return LoggedUser.runAs(from.getUser(), new Callable<Payment>(){

            @Override
            public Payment call() throws Exception {
                if (!ReceivePaymentAction.this.accessService.isChannelEnabledForMember("posweb", from)) {
                    throw new InvalidUserForChannelException(from.getUsername());
                }
                ValidationException validation = ReceivePaymentAction.this.checkCredentials(context, from);
                validation.throwIfHasErrors();
                dto.setShowScheduledToReceiver(true);
                return ReceivePaymentAction.this.getPaymentService().doPayment(dto);
            }
        });
    }

    @Override
    protected OperatorPermission getPermission() {
        return OperatorPermission.PAYMENTS_POSWEB_RECEIVE_PAYMENT;
    }

    @Override
    protected DataBinder<DoPaymentDTO> initDataBinder() {
        BeanBinder binder = (BeanBinder)super.initDataBinder();
        binder.getMappings().remove("from");
        return binder;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        super.prepareForm(context);
        ReceivePaymentForm form = (ReceivePaymentForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        Channel channel = this.posWebChannel();
        Channel.Credentials credentials = channel.getCredentials();
        boolean numericCredentials = false;
        boolean uppercasedCredentials = false;
        switch (credentials) {
            case PIN: 
            case CARD_SECURITY_CODE: {
                numericCredentials = true;
                break;
            }
            case LOGIN_PASSWORD: {
                numericCredentials = this.settingsService.getAccessSettings().isNumericPassword();
                break;
            }
            case TRANSACTION_PASSWORD: {
                numericCredentials = StringUtils.containsOnly((String)this.settingsService.getAccessSettings().getTransactionPasswordChars(), (String)"0123456789");
                uppercasedCredentials = true;
            }
        }
        PrincipalType selectedPrincipalType = this.channelService.resolvePrincipalType(channel.getInternalName(), form.getPrincipalType());
        form.setPrincipalType(selectedPrincipalType.toString());
        TreeMap<String, PrincipalType> principalTypes = new TreeMap<String, PrincipalType>();
        for (PrincipalType principalType : channel.getPrincipalTypes()) {
            principalTypes.put(this.principalTypeLabel(principalType), principalType);
        }
        request.setAttribute("principalTypes", principalTypes);
        request.setAttribute("selectedPrincipalType", (Object)selectedPrincipalType);
        request.setAttribute("selectedPrincipalLabel", (Object)this.principalTypeLabel(selectedPrincipalType));
        request.setAttribute("credentials", (Object)credentials);
        request.setAttribute("numericCredentials", (Object)numericCredentials);
        request.setAttribute("uppercasedCredentials", (Object)uppercasedCredentials);
        request.setAttribute("credentialsKey", (Object)this.getCredentialsKey());
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        request.setAttribute("today", (Object)localSettings.getRawDateConverter().toString(Calendar.getInstance()));
        RequestHelper.storeEnum(request, SchedulingType.class, "schedulingTypes");
    }

    @Override
    protected DoPaymentDTO resolvePaymentDTO(ActionContext context) {
        Member member = (Member)context.getAccountOwner();
        ReceivePaymentForm form = (ReceivePaymentForm)((Object)context.getForm());
        DoPaymentDTO payment = this.getDataBinder().readFromString((Object)form);
        try {
            Member fromMember = CoercionHelper.coerce(Member.class, form.getFrom());
            payment.setFrom(fromMember);
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
        payment.setChannel("posweb");
        payment.setContext(TransactionContext.PAYMENT);
        payment.setTo(member);
        if (context.isOperator()) {
            payment.setReceiver((Element)context.getElement());
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        SchedulingType schedulingType = CoercionHelper.coerce(SchedulingType.class, form.getSchedulingType());
        if (schedulingType == null) {
            schedulingType = SchedulingType.IMMEDIATELY;
        }
        List<ScheduledPaymentDTO> installments = null;
        switch (schedulingType) {
            case SINGLE_FUTURE: {
                ScheduledPaymentDTO installment = new ScheduledPaymentDTO();
                installment.setAmount(payment.getAmount());
                installment.setDate(localSettings.getRawDateConverter().valueOf(form.getScheduledFor()));
                installments = Collections.singletonList(installment);
                break;
            }
            case MULTIPLE_FUTURE: {
                int paymentCount = CoercionHelper.coerce(Integer.TYPE, form.getPaymentCount());
                Calendar firstPaymentDate = localSettings.getRawDateConverter().valueOf(form.getFirstPaymentDate());
                if (paymentCount <= 0 || firstPaymentDate == null) break;
                ProjectionDTO projection = new ProjectionDTO();
                projection.setTransferType(payment.getTransferType());
                projection.setAmount(payment.getAmount());
                projection.setFirstExpirationDate(firstPaymentDate);
                projection.setPaymentCount(paymentCount);
                installments = this.getPaymentService().calculatePaymentProjection(projection);
            }
        }
        payment.setPayments(installments);
        return payment;
    }

    @Override
    protected void validateForm(ActionContext context) {
        DoPaymentDTO dto = this.resolvePaymentDTO(context);
        dto.setPayments(null);
        ValidationException validation = null;
        try {
            this.getPaymentService().validate(dto);
            validation = new ValidationException();
        }
        catch (ValidationException e) {
            validation = e;
        }
        ReceivePaymentForm form = (ReceivePaymentForm)((Object)context.getForm());
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        AccountOwner from = dto.getFrom();
        if (from instanceof Member) {
            validation.setPropertyKey("paymentCount", "transfer.paymentCount");
            validation.setPropertyKey("firstPaymentDate", "transfer.firstPaymentDate");
            validation.setPropertyKey("scheduledFor", "transfer.scheduledFor");
            validation.setPropertyKey("_credentials", this.getCredentialsKey());
            SchedulingType schedulingType = CoercionHelper.coerce(SchedulingType.class, form.getSchedulingType());
            if (schedulingType == null) {
                schedulingType = SchedulingType.IMMEDIATELY;
            }
            switch (schedulingType) {
                case SINGLE_FUTURE: {
                    Calendar scheduledFor = null;
                    try {
                        scheduledFor = localSettings.getRawDateConverter().valueOf(form.getScheduledFor());
                        ValidationError error = null;
                        error = scheduledFor == null ? new RequiredError(new Object[0]) : TodayValidation.future().validate(null, null, scheduledFor);
                        if (error == null) break;
                        validation.addPropertyError("scheduledFor", error);
                    }
                    catch (Exception e) {
                        validation.addPropertyError("scheduledFor", new InvalidError());
                    }
                    break;
                }
                case MULTIPLE_FUTURE: {
                    try {
                        Integer paymentCount = CoercionHelper.coerce(Integer.class, form.getPaymentCount());
                        ValidationError error = null;
                        error = paymentCount == null ? new RequiredError(new Object[0]) : PositiveNonZeroValidation.instance().validate(null, null, paymentCount);
                        if (error != null) {
                            validation.addPropertyError("paymentCount", new InvalidError());
                        }
                    }
                    catch (Exception e) {
                        validation.addPropertyError("paymentCount", new InvalidError());
                    }
                    Calendar firstPaymentDate = null;
                    try {
                        firstPaymentDate = localSettings.getRawDateConverter().valueOf(form.getFirstPaymentDate());
                        ValidationError error = null;
                        error = firstPaymentDate == null ? new RequiredError(new Object[0]) : TodayValidation.futureOrToday().validate(null, null, firstPaymentDate);
                        if (error == null) break;
                        validation.addPropertyError("firstPaymentDate", error);
                        break;
                    }
                    catch (Exception e) {
                        validation.addPropertyError("firstPaymentDate", new InvalidError());
                    }
                }
            }
            if (StringUtils.isEmpty((String)form.getCredentials())) {
                validation.addPropertyError("_credentials", new RequiredError(new Object[0]));
            } else if (!validation.hasErrors()) {
                Member member = (Member)this.elementService.load(((Member)from).getId(), new Relationship[0]);
                validation = this.checkCredentials(context, member);
            }
        }
        validation.throwIfHasErrors();
    }

    private ValidationException checkCredentials(ActionContext context, Member member) {
        String cardFormProperty = "_card";
        String credentialsFormProperty = "_credentials";
        ValidationException validation = new ValidationException();
        validation.setPropertyKey("_card", "posweb.client.card");
        validation.setPropertyKey("_credentials", this.getCredentialsKey());
        ReceivePaymentForm form = (ReceivePaymentForm)((Object)context.getForm());
        String credentials = form.getCredentials();
        if (StringUtils.isEmpty((String)credentials)) {
            validation.addPropertyError("_credentials", new RequiredError(new Object[0]));
        } else {
            Member relatedMember = (Member)context.getAccountOwner();
            try {
                MemberUser payer = CoercionHelper.coerce(MemberUser.class, form.getFrom());
                this.accessService.checkCredentials(this.posWebChannel(), payer, credentials, context.getRequest().getRemoteAddr(), relatedMember);
            }
            catch (InvalidCardException e) {
                validation.addPropertyError("_card", new InvalidError());
            }
            catch (InvalidCredentialsException e) {
                validation.addPropertyError("_credentials", new InvalidError());
            }
            catch (BlockedCredentialsException e) {
                String key;
                switch (e.getCredentialsType()) {
                    case TRANSACTION_PASSWORD: {
                        key = "transactionPassword.error.blockedByTrials";
                        break;
                    }
                    case PIN: {
                        key = "pin.error.blocked";
                        break;
                    }
                    case CARD_SECURITY_CODE: {
                        key = "cardSecurityCode.error.blocked";
                        break;
                    }
                    default: {
                        key = "login.error.blocked";
                    }
                }
                validation.addGeneralError(new ValidationError(key, new Object[0]));
            }
        }
        return validation;
    }

    private String getCredentialsKey() {
        String credentialsKey;
        Channel channel = this.posWebChannel();
        switch (channel.getCredentials()) {
            case PIN: {
                credentialsKey = "posweb.client.pin";
                break;
            }
            case LOGIN_PASSWORD: {
                credentialsKey = "posweb.client.loginPassword";
                break;
            }
            case TRANSACTION_PASSWORD: {
                credentialsKey = "posweb.client.transactionPassword";
                break;
            }
            case CARD_SECURITY_CODE: {
                credentialsKey = "posweb.client.cardSecurityCode";
                break;
            }
            default: {
                throw new IllegalStateException("Cannot use credentials type " + channel.getCredentials() + " for PosWeb");
            }
        }
        return credentialsKey;
    }

    private Channel posWebChannel() {
        Channel channel = this.channelService.loadByInternalName("posweb");
        return channel;
    }

    private String principalTypeLabel(PrincipalType principalType) {
        Channel.Principal principal = principalType.getPrincipal();
        switch (principal) {
            case USER: {
                return this.messageHelper.message("posweb.client.username", new Object[0]);
            }
            case CUSTOM_FIELD: {
                return principalType.getCustomField().getName();
            }
        }
        return this.messageHelper.message(principal.getKey(), new Object[0]);
    }
}

