/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.posweb;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.posweb.SearchTransactionsForm;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPaymentQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentService;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.TransformedIteratorList;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import org.apache.struts.action.ActionForward;

public class SearchTransactionsAction
extends BaseAction {
    private PaymentService paymentService;
    private ScheduledPaymentService scheduledPaymentService;

    public static List<Entry> listScheduledPayments(ScheduledPaymentService scheduledPaymentService, Member owner, Calendar date) {
        ScheduledPaymentQuery schedQuery = new ScheduledPaymentQuery();
        schedQuery.setIterateAll();
        schedQuery.setOwner(owner);
        schedQuery.setSearchType(ScheduledPaymentQuery.SearchType.INCOMING);
        schedQuery.setPeriod(Period.day(date));
        List<ScheduledPayment> scheduledPayments = scheduledPaymentService.search(schedQuery);
        TransformedIteratorList scheduledPaymentEntries = new TransformedIteratorList(new TransformPaymentToEntry(owner), scheduledPayments);
        return scheduledPaymentEntries;
    }

    public static List<Entry> listTransfers(PaymentService paymentService, Member owner, Calendar date) {
        TransferQuery transferQuery = new TransferQuery();
        transferQuery.setIterateAll();
        transferQuery.setOwner(owner);
        transferQuery.setPeriod(Period.day(date));
        transferQuery.setStatus(Payment.Status.PROCESSED);
        List<Transfer> transfers = paymentService.search(transferQuery);
        TransformedIteratorList transferEntries = new TransformedIteratorList(new TransformPaymentToEntry(owner), transfers);
        return transferEntries;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public void setScheduledPaymentService(ScheduledPaymentService scheduledPaymentService) {
        this.scheduledPaymentService = scheduledPaymentService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        SearchTransactionsForm form = (SearchTransactionsForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        CalendarConverter converter = this.settingsService.getLocalSettings().getRawDateConverter();
        Calendar date = converter.valueOf(form.getDate());
        if (date == null) {
            date = Calendar.getInstance();
            form.setDate(converter.toString(date));
        }
        Member owner = context.getMember();
        request.setAttribute("transfers", SearchTransactionsAction.listTransfers(this.paymentService, owner, date));
        request.setAttribute("scheduledPayments", SearchTransactionsAction.listScheduledPayments(this.scheduledPaymentService, owner, date));
        return context.getInputForward();
    }

    private static class TransformPaymentToEntry<P extends Payment>
    implements Transformer<P, Entry> {
        private Member owner;

        private TransformPaymentToEntry(Member owner) {
            this.owner = owner;
        }

        @Override
        public Entry transform(P payment) {
            Entry entry = new Entry();
            entry.setPayment((Payment)payment);
            boolean isCredit = this.owner.equals(((Payment)payment).getActualToOwner());
            BigDecimal amount = ((Payment)payment).getActualAmount();
            entry.setAmount(isCredit ? amount : amount.negate());
            entry.setRelatedAccount(isCredit ? ((Payment)payment).getActualFrom() : ((Payment)payment).getActualTo());
            return entry;
        }
    }

    public static class Entry {
        private Payment payment;
        private BigDecimal amount;
        private Account relatedAccount;

        public BigDecimal getAmount() {
            return this.amount;
        }

        public Payment getPayment() {
            return this.payment;
        }

        public Account getRelatedAccount() {
            return this.relatedAccount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public void setPayment(Payment payment) {
            this.payment = payment;
        }

        public void setRelatedAccount(Account relatedAccount) {
            this.relatedAccount = relatedAccount;
        }
    }
}

