/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.posweb;

import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseReceiptPrintAjaxAction;
import nl.strohalm.cyclos.controls.posweb.SearchTransactionsAction;
import nl.strohalm.cyclos.controls.posweb.SearchTransactionsForm;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.printsettings.ReceiptPrinterSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentService;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class TransactionsReceiptAction
extends BaseReceiptPrintAjaxAction {
    private PaymentService paymentService;
    private ScheduledPaymentService scheduledPaymentService;

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public void setScheduledPaymentService(ScheduledPaymentService scheduledPaymentService) {
        this.scheduledPaymentService = scheduledPaymentService;
    }

    @Override
    protected String resolveText(ActionContext context, ReceiptPrinterSettings receiptPrinterSettings) {
        SearchTransactionsForm form = (SearchTransactionsForm)((Object)context.getForm());
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        CalendarConverter rawDateConverter = localSettings.getRawDateConverter();
        Calendar date = rawDateConverter.valueOf(form.getDate());
        if (date == null) {
            date = Calendar.getInstance();
        }
        Member owner = context.getMember();
        CalendarConverter timeConverter = localSettings.getTimeConverter();
        boolean txNumberUsed = localSettings.getTransactionNumber() != null && localSettings.getTransactionNumber().isValid();
        StringBuilder out = new StringBuilder();
        out.append(context.message("receipt.posweb.transactions.header", localSettings.getApplicationName())).append('\n');
        out.append(context.message("receipt.posweb.transactions.member", owner.getName())).append('\n');
        out.append(context.message("receipt.posweb.transactions.date", rawDateConverter.toString(date))).append('\n');
        out.append('\n').append(context.message("receipt.posweb.transactions.transfers", new Object[0])).append('\n');
        List<SearchTransactionsAction.Entry> transfers = SearchTransactionsAction.listTransfers(this.paymentService, owner, date);
        if (transfers.isEmpty()) {
            out.append(context.message("receipt.posweb.transactions.noTransfers", new Object[0])).append('\n');
        } else {
            for (SearchTransactionsAction.Entry entry : transfers) {
                Transfer transfer = (Transfer)entry.getPayment();
                String time = timeConverter.toString(transfer.getActualDate());
                String transactionNumber = StringUtils.trimToEmpty((String)(txNumberUsed ? transfer.getTransactionNumber() : null));
                String amount = localSettings.getUnitsConverter(transfer.getFrom().getType().getCurrency().getPattern()).toString(transfer.getActualAmount());
                String username = entry.getRelatedAccount().getOwnerName();
                out.append(context.message("receipt.posweb.transactions.transfer", time, transactionNumber, amount, username)).append('\n');
            }
        }
        DataIteratorHelper.close(transfers);
        List<SearchTransactionsAction.Entry> scheduledPayments = SearchTransactionsAction.listScheduledPayments(this.scheduledPaymentService, owner, date);
        if (CollectionUtils.isNotEmpty(scheduledPayments)) {
            out.append('\n').append(context.message("receipt.posweb.transactions.scheduledPayments", new Object[0])).append('\n');
            for (SearchTransactionsAction.Entry entry : scheduledPayments) {
                ScheduledPayment scheduledPayment = (ScheduledPayment)entry.getPayment();
                String time = timeConverter.toString(scheduledPayment.getDate());
                int installmentsCount = scheduledPayment.getTransfers().size();
                Integer installmentNumber = scheduledPayment.getFirstOpenPaymentIndex();
                String installments = installmentNumber == null ? String.valueOf(installmentsCount) : installmentNumber + "/" + installmentsCount;
                String firstDate = rawDateConverter.toString(scheduledPayment.getActualDate());
                String amount = localSettings.getUnitsConverter(scheduledPayment.getFrom().getType().getCurrency().getPattern()).toString(scheduledPayment.getAmount());
                String username = entry.getRelatedAccount().getOwnerName();
                out.append(context.message("receipt.posweb.transactions.scheduledPayment", time, installments, firstDate, amount, username)).append('\n');
            }
            DataIteratorHelper.close(scheduledPayments);
        }
        return out.toString();
    }
}

