/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports;

import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.reports.CurrentStateReportForm;
import nl.strohalm.cyclos.entities.reports.CurrentStateReportVO;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.reports.CurrentStateReportParameters;
import nl.strohalm.cyclos.services.reports.CurrentStateReportService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import org.apache.struts.action.ActionForward;

public class CurrentStateReportAction
extends BaseFormAction {
    private CurrentStateReportService currentStateReportService;
    private DataBinder<CurrentStateReportParameters> dataBinder;

    @Inject
    public void setCurrentStateReportService(CurrentStateReportService currentStateReportService) {
        this.currentStateReportService = currentStateReportService;
    }

    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        try {
            this.prepareForm(context);
        }
        catch (Exception e) {
            return context.sendError("reports.error.formDisplayError", new Object[0]);
        }
        return context.getInputForward();
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        CurrentStateReportForm form = (CurrentStateReportForm)((Object)context.getForm());
        CurrentStateReportParameters params = this.getDataBinder().readFromString(form.getCurrentStateReport());
        if (params.getTimePointType() == CurrentStateReportParameters.TimePointType.TIME_POINT_HISTORY) {
            params.setInvoices(false);
            params.setLoans(false);
            params.setReferences(false);
            request.setAttribute("historyTime", (Object)params.getTimePoint());
        }
        CurrentStateReportVO report = this.currentStateReportService.getCurrentStateReport(params);
        request.setAttribute("dto", (Object)params);
        request.setAttribute("singleCurrency", (Object)(report.getCurrencies().size() == 1 ? 1 : 0));
        request.setAttribute("report", (Object)report);
        return context.getSuccessForward();
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        CurrentStateReportForm form = (CurrentStateReportForm)((Object)context.getForm());
        CurrentStateReportParameters params = new CurrentStateReportParameters();
        this.getDataBinder().writeAsString(form.getCurrentStateReport(), params);
    }

    private DataBinder<CurrentStateReportParameters> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<CurrentStateReportParameters> binder = BeanBinder.instance(CurrentStateReportParameters.class);
            binder.registerBinder("ads", PropertyBinder.instance(Boolean.TYPE, "ads"));
            binder.registerBinder("invoices", PropertyBinder.instance(Boolean.TYPE, "invoices"));
            binder.registerBinder("loans", PropertyBinder.instance(Boolean.TYPE, "loans"));
            binder.registerBinder("memberAccountInformation", PropertyBinder.instance(Boolean.TYPE, "memberAccountInformation"));
            binder.registerBinder("memberGroupInformation", PropertyBinder.instance(Boolean.TYPE, "memberGroupInformation"));
            binder.registerBinder("references", PropertyBinder.instance(Boolean.TYPE, "references"));
            binder.registerBinder("systemAccountInformation", PropertyBinder.instance(Boolean.TYPE, "systemAccountInformation"));
            binder.registerBinder("timePoint", PropertyBinder.instance(Calendar.class, "timePoint", localSettings.getDateTimeConverter()));
            binder.registerBinder("timePointType", PropertyBinder.instance(CurrentStateReportParameters.TimePointType.class, "timePointType"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

