/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.members.list;

import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseCsvAction;
import nl.strohalm.cyclos.controls.reports.members.list.MembersListReportDTO;
import nl.strohalm.cyclos.controls.reports.members.list.MembersListReportForm;
import nl.strohalm.cyclos.controls.reports.members.list.MembersListReportHandler;
import nl.strohalm.cyclos.controls.reports.members.list.MembersListReportVOIterator;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.reports.MembersReportVO;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.csv.CSVWriter;

public class ExportMembersListReportToCsvAction
extends BaseCsvAction {
    private MembersListReportHandler reportHandler;

    public MembersListReportHandler getReportHandler() {
        if (this.reportHandler == null) {
            this.reportHandler = new MembersListReportHandler(this.settingsService.getLocalSettings());
            SpringHelper.injectBeans(this.getServlet().getServletContext(), (Object)this.reportHandler);
        }
        return this.reportHandler;
    }

    protected List<?> executeQuery(ActionContext context) {
        AbstractList<MembersReportVO> list = null;
        final MembersListReportVOIterator voIterator = this.getReportHandler().handleReport(context);
        list = new AbstractList<MembersReportVO>(){

            @Override
            public MembersReportVO get(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<MembersReportVO> iterator() {
                return voIterator;
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }
        };
        return list;
    }

    @Override
    protected String fileName(ActionContext context) {
        Object loggedUser = context.getUser();
        return "members_report_" + ((User)loggedUser).getUsername() + ".csv";
    }

    protected CSVWriter<MembersReportVO> resolveCSVWriter(ActionContext context) {
        BeanBinder<MembersListReportDTO> binder = this.getReportHandler().getDataBinder();
        MembersListReportForm form = (MembersListReportForm)((Object)context.getForm());
        MembersListReportDTO dto = binder.readFromString(form.getMembersListReport());
        List groups = (List)dto.getGroups();
        LocalSettings settings = this.settingsService.getLocalSettings();
        CSVWriter<MembersReportVO> csv = CSVWriter.instance(MembersReportVO.class, settings);
        csv.addColumn(context.message("member.username", new Object[0]), "member.username");
        if (dto.isMemberName()) {
            csv.addColumn(context.message("member.name", new Object[0]), "member.name");
        }
        if (dto.isBrokerUsername()) {
            csv.addColumn(context.message("member.brokerUsername", new Object[0]), "member.broker.username");
        }
        if (dto.isBrokerName()) {
            csv.addColumn(context.message("member.brokerName", new Object[0]), "member.broker.name");
        }
        if (dto.isAccountsInformation()) {
            Collection<AccountType> accountTypes = this.getReportHandler().getAccountTypes(groups);
            for (AccountType accountType : accountTypes) {
                if (dto.isAccountsCredits()) {
                    csv.addColumn(accountType.getName() + ": " + context.message("account.creditLimit", new Object[0]), "accountsCredits", new AccountTypeConverter(accountType));
                }
                if (dto.isAccountsUpperCredits()) {
                    csv.addColumn(accountType.getName() + ": " + context.message("account.upperCreditLimit", new Object[0]), "accountsUpperCredits", new AccountTypeConverter(accountType));
                }
                if (!dto.isAccountsBalances()) continue;
                csv.addColumn(accountType.getName() + ": " + context.message("account.balance", new Object[0]), "accountsBalances", new AccountTypeConverter(accountType));
            }
        }
        if (dto.isActiveAds()) {
            csv.addColumn(context.message("reports.members.ads", new Object[0]) + ": " + context.message("reports.members.ads.active", new Object[0]), "ads", new AdConverter(Ad.Status.ACTIVE));
        }
        if (dto.isExpiredAds()) {
            csv.addColumn(context.message("reports.members.ads", new Object[0]) + ": " + context.message("reports.members.ads.expired", new Object[0]), "ads", new AdConverter(Ad.Status.EXPIRED));
        }
        if (dto.isPermanentAds()) {
            csv.addColumn(context.message("reports.members.ads", new Object[0]) + ": " + context.message("reports.members.ads.permanent", new Object[0]), "ads", new AdConverter(Ad.Status.PERMANENT));
        }
        if (dto.isScheduledAds()) {
            csv.addColumn(context.message("reports.members.ads", new Object[0]) + ": " + context.message("reports.members.ads.scheduled", new Object[0]), "ads", new AdConverter(Ad.Status.SCHEDULED));
        }
        if (dto.isGivenReferences()) {
            csv.addColumn(context.message("reference.title.given.my", new Object[0]) + ": " + context.message("reference.level.VERY_BAD", new Object[0]), "givenReferences", new ReferenceConverter(Reference.Level.VERY_BAD));
            csv.addColumn(context.message("reference.title.given.my", new Object[0]) + ": " + context.message("reference.level.BAD", new Object[0]), "givenReferences", new ReferenceConverter(Reference.Level.BAD));
            csv.addColumn(context.message("reference.title.given.my", new Object[0]) + ": " + context.message("reference.level.NEUTRAL", new Object[0]), "givenReferences", new ReferenceConverter(Reference.Level.NEUTRAL));
            csv.addColumn(context.message("reference.title.given.my", new Object[0]) + ": " + context.message("reference.level.GOOD", new Object[0]), "givenReferences", new ReferenceConverter(Reference.Level.GOOD));
            csv.addColumn(context.message("reference.title.given.my", new Object[0]) + ": " + context.message("reference.level.VERY_GOOD", new Object[0]), "givenReferences", new ReferenceConverter(Reference.Level.VERY_GOOD));
        }
        if (dto.isReceivedReferences()) {
            csv.addColumn(context.message("reference.title.received.my", new Object[0]) + ": " + context.message("reference.level.VERY_BAD", new Object[0]), "receivedReferences", new ReferenceConverter(Reference.Level.VERY_BAD));
            csv.addColumn(context.message("reference.title.received.my", new Object[0]) + ": " + context.message("reference.level.BAD", new Object[0]), "receivedReferences", new ReferenceConverter(Reference.Level.BAD));
            csv.addColumn(context.message("reference.title.received.my", new Object[0]) + ": " + context.message("reference.level.NEUTRAL", new Object[0]), "receivedReferences", new ReferenceConverter(Reference.Level.NEUTRAL));
            csv.addColumn(context.message("reference.title.received.my", new Object[0]) + ": " + context.message("reference.level.GOOD", new Object[0]), "receivedReferences", new ReferenceConverter(Reference.Level.GOOD));
            csv.addColumn(context.message("reference.title.received.my", new Object[0]) + ": " + context.message("reference.level.VERY_GOOD", new Object[0]), "receivedReferences", new ReferenceConverter(Reference.Level.VERY_GOOD));
        }
        return csv;
    }

    class ReferenceConverter
    implements Converter<Map<Reference.Level, Integer>> {
        private static final long serialVersionUID = 366134132591193802L;
        private final Reference.Level referenceLevel;

        ReferenceConverter(Reference.Level referenceLevel) {
            this.referenceLevel = referenceLevel;
        }

        @Override
        public String toString(Map<Reference.Level, Integer> map) {
            Integer value = map.get(this.referenceLevel);
            if (value == null) {
                return "";
            }
            return value.toString();
        }

        @Override
        public Map<Reference.Level, Integer> valueOf(String string) {
            return null;
        }
    }

    class AdConverter
    implements Converter<Map<Ad.Status, Integer>> {
        private static final long serialVersionUID = -6394932401168004253L;
        private final Ad.Status adStatus;

        AdConverter(Ad.Status adStatus) {
            this.adStatus = adStatus;
        }

        @Override
        public String toString(Map<Ad.Status, Integer> map) {
            Integer value = map.get((Object)this.adStatus);
            if (value == null) {
                return "";
            }
            return value.toString();
        }

        @Override
        public Map<Ad.Status, Integer> valueOf(String string) {
            return null;
        }
    }

    class AccountTypeConverter
    implements Converter<Map<AccountType, BigDecimal>> {
        private static final long serialVersionUID = 5139693651536516412L;
        private final AccountType accountType;

        AccountTypeConverter(AccountType accountType) {
            this.accountType = accountType;
        }

        @Override
        public String toString(Map<AccountType, BigDecimal> map) {
            BigDecimal value = map.get(this.accountType);
            if (value == null) {
                return "";
            }
            return ExportMembersListReportToCsvAction.this.settingsService.getLocalSettings().getNumberConverter().toString(value);
        }

        @Override
        public Map<AccountType, BigDecimal> valueOf(String string) {
            return null;
        }
    }
}

