/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.members.list;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.reports.members.list.MembersListReportDTO;
import nl.strohalm.cyclos.controls.reports.members.list.MembersListReportForm;
import nl.strohalm.cyclos.controls.reports.members.list.MembersListReportHandler;
import nl.strohalm.cyclos.controls.reports.members.list.MembersListReportVOIterator;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import org.apache.struts.action.ActionForward;

public class MembersListReportAction
extends BaseFormAction {
    private MembersListReportHandler reportHandler;

    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        AdminGroup adminGroup = (AdminGroup)context.getGroup();
        adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
        TreeSet<MemberGroup> groups = new TreeSet<MemberGroup>(adminGroup.getManagesGroups());
        HttpServletRequest request = context.getRequest();
        request.setAttribute("groups", groups);
        return context.getInputForward();
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        MembersListReportVOIterator voIterator = this.getReportHandler().handleReport(context);
        HttpServletRequest request = context.getRequest();
        MembersListReportForm form = (MembersListReportForm)((Object)context.getForm());
        MembersListReportDTO dto = this.getReportHandler().getDataBinder().readFromString(form.getMembersListReport());
        request.setAttribute("dto", (Object)dto);
        if (dto.isAccountsInformation()) {
            List groups = (List)dto.getGroups();
            Collection<AccountType> accountTypes = this.getReportHandler().getAccountTypes(groups);
            request.setAttribute("accountTypes", accountTypes);
        }
        request.setAttribute("voIterator", (Object)voIterator);
        RequestHelper.storeEnumMap(request, Ad.Status.class, "adStatus");
        RequestHelper.storeEnumMap(request, Reference.Level.class, "referenceLevels");
        return context.getSuccessForward();
    }

    private MembersListReportHandler getReportHandler() {
        if (this.reportHandler == null) {
            this.reportHandler = new MembersListReportHandler(this.settingsService.getLocalSettings());
            SpringHelper.injectBeans(this.getServlet().getServletContext(), (Object)this.reportHandler);
        }
        return this.reportHandler;
    }
}

