/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.members.list;

import java.util.Calendar;
import java.util.Collection;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;

public class MembersListReportDTO {
    private Collection<MemberGroup> groups;
    private Member broker;
    private boolean memberName;
    private boolean brokerName;
    private boolean brokerUsername;
    private boolean activeAds;
    private boolean expiredAds;
    private boolean permanentAds;
    private boolean scheduledAds;
    private boolean givenReferences;
    private boolean receivedReferences;
    private boolean accountsBalances;
    private boolean accountsCredits;
    private boolean accountsUpperCredits;
    private Calendar period;
    private PeriodType periodType;

    public int getAccountsColSpan() {
        int count = 0;
        if (this.isAccountsCredits()) {
            ++count;
        }
        if (this.isAccountsUpperCredits()) {
            ++count;
        }
        if (this.isAccountsBalances()) {
            ++count;
        }
        return count;
    }

    public int getAdsColSpan() {
        int count = 0;
        if (this.isActiveAds()) {
            ++count;
        }
        if (this.isExpiredAds()) {
            ++count;
        }
        if (this.isPermanentAds()) {
            ++count;
        }
        if (this.isScheduledAds()) {
            ++count;
        }
        return count;
    }

    public Member getBroker() {
        return this.broker;
    }

    public int getBrokerColSpan() {
        int colspan = 0;
        if (this.isBrokerName()) {
            ++colspan;
        }
        if (this.isBrokerUsername()) {
            ++colspan;
        }
        return colspan;
    }

    public Collection<MemberGroup> getGroups() {
        return this.groups;
    }

    public int getMemberColSpan() {
        if (this.isMemberName()) {
            return 2;
        }
        return 1;
    }

    public Calendar getPeriod() {
        return this.period;
    }

    public PeriodType getPeriodType() {
        return this.periodType;
    }

    public boolean isAccountsBalances() {
        return this.accountsBalances;
    }

    public boolean isAccountsCredits() {
        return this.accountsCredits;
    }

    public boolean isAccountsInformation() {
        return this.isAccountsCredits() || this.isAccountsUpperCredits() || this.isAccountsBalances();
    }

    public boolean isAccountsUpperCredits() {
        return this.accountsUpperCredits;
    }

    public boolean isActiveAds() {
        return this.activeAds;
    }

    public boolean isAds() {
        return this.activeAds || this.expiredAds || this.permanentAds || this.scheduledAds;
    }

    public boolean isBrokerName() {
        return this.brokerName;
    }

    public boolean isBrokerUsername() {
        return this.brokerUsername;
    }

    public boolean isExpiredAds() {
        return this.expiredAds;
    }

    public boolean isGivenReferences() {
        return this.givenReferences;
    }

    public boolean isMemberName() {
        return this.memberName;
    }

    public boolean isPermanentAds() {
        return this.permanentAds;
    }

    public boolean isReceivedReferences() {
        return this.receivedReferences;
    }

    public boolean isScheduledAds() {
        return this.scheduledAds;
    }

    public void setAccountsBalances(boolean accountsBalances) {
        this.accountsBalances = accountsBalances;
    }

    public void setAccountsCredits(boolean accountsCredits) {
        this.accountsCredits = accountsCredits;
    }

    public void setAccountsUpperCredits(boolean accountsUpperCredits) {
        this.accountsUpperCredits = accountsUpperCredits;
    }

    public void setActiveAds(boolean activeAds) {
        this.activeAds = activeAds;
    }

    public void setBroker(Member broker) {
        this.broker = broker;
    }

    public void setBrokerName(boolean brokerName) {
        this.brokerName = brokerName;
    }

    public void setBrokerUsername(boolean brokerUsername) {
        this.brokerUsername = brokerUsername;
    }

    public void setExpiredAds(boolean expiredAds) {
        this.expiredAds = expiredAds;
    }

    public void setGivenReferences(boolean givenReferences) {
        this.givenReferences = givenReferences;
    }

    public void setGroups(Collection<MemberGroup> groups) {
        this.groups = groups;
    }

    public void setMemberName(boolean memberName) {
        this.memberName = memberName;
    }

    public void setPeriod(Calendar period) {
        this.period = period;
    }

    public void setPeriodType(PeriodType periodType) {
        this.periodType = periodType;
    }

    public void setPermanentAds(boolean permanentAds) {
        this.permanentAds = permanentAds;
    }

    public void setReceivedReferences(boolean receivedReferences) {
        this.receivedReferences = receivedReferences;
    }

    public void setScheduledAds(boolean scheduledAds) {
        this.scheduledAds = scheduledAds;
    }

    public static enum PeriodType {
        PERIOD_CURRENT,
        PERIOD_HISTORY;

    }
}

