/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.members.list;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.reports.members.list.MembersListReportDTO;
import nl.strohalm.cyclos.controls.reports.members.list.MembersListReportForm;
import nl.strohalm.cyclos.controls.reports.members.list.MembersListReportVOIterator;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.MemberQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.MemberAccountTypeQuery;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class MembersListReportHandler {
    private AccountTypeService accountTypeService;
    private ElementService elementService;
    private BeanBinder<MembersListReportDTO> binder;
    private LocalSettings settings = null;

    public MembersListReportHandler(LocalSettings settings) {
        this.settings = settings;
    }

    public Collection<AccountType> getAccountTypes(List<MemberGroup> groups) {
        MemberAccountTypeQuery atQuery = new MemberAccountTypeQuery();
        atQuery.setRelatedToGroups(groups);
        List<AccountType> accountTypes = this.accountTypeService.search(atQuery);
        return accountTypes;
    }

    public BeanBinder<MembersListReportDTO> getDataBinder() {
        if (this.binder == null || this.settings == null) {
            BeanBinder<MembersListReportDTO> temp = BeanBinder.instance(MembersListReportDTO.class);
            temp.registerBinder("broker", PropertyBinder.instance(Member.class, "brokerId"));
            temp.registerBinder("memberName", PropertyBinder.instance(Boolean.TYPE, "memberName"));
            temp.registerBinder("brokerUsername", PropertyBinder.instance(Boolean.TYPE, "brokerUsername"));
            temp.registerBinder("brokerName", PropertyBinder.instance(Boolean.TYPE, "brokerName"));
            temp.registerBinder("groups", SimpleCollectionBinder.instance(MemberGroup.class, "groups"));
            temp.registerBinder("activeAds", PropertyBinder.instance(Boolean.TYPE, "activeAds"));
            temp.registerBinder("expiredAds", PropertyBinder.instance(Boolean.TYPE, "expiredAds"));
            temp.registerBinder("permanentAds", PropertyBinder.instance(Boolean.TYPE, "permanentAds"));
            temp.registerBinder("scheduledAds", PropertyBinder.instance(Boolean.TYPE, "scheduledAds"));
            temp.registerBinder("givenReferences", PropertyBinder.instance(Boolean.TYPE, "givenReferences"));
            temp.registerBinder("receivedReferences", PropertyBinder.instance(Boolean.TYPE, "receivedReferences"));
            temp.registerBinder("accountsBalances", PropertyBinder.instance(Boolean.TYPE, "accountsBalances"));
            temp.registerBinder("accountsCredits", PropertyBinder.instance(Boolean.TYPE, "accountsCredits"));
            temp.registerBinder("accountsUpperCredits", PropertyBinder.instance(Boolean.TYPE, "accountsUpperCredits"));
            if (this.settings != null) {
                temp.registerBinder("period", PropertyBinder.instance(Calendar.class, "period", this.settings.getDateTimeConverter()));
            }
            temp.registerBinder("periodType", PropertyBinder.instance(MembersListReportDTO.PeriodType.class, "periodType"));
            this.binder = temp;
        }
        return this.binder;
    }

    public MembersListReportVOIterator handleReport(ActionContext context) {
        MembersListReportForm form = (MembersListReportForm)((Object)context.getForm());
        MembersListReportDTO dto = this.getDataBinder().readFromString(form.getMembersListReport());
        List groups = (List)dto.getGroups();
        Member broker = dto.getBroker();
        MemberQuery query = new MemberQuery();
        query.fetch(Element.Relationships.USER);
        query.setGroups(groups);
        query.setBroker(broker);
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.setPageParameters(new PageParameters(-1, 0));
        List<? extends Element> members = this.elementService.searchAtDate(query, dto.getPeriod());
        Collection<AccountType> accountTypes = this.getAccountTypes(groups);
        MembersListReportVOIterator voIterator = new MembersListReportVOIterator(dto, accountTypes, members);
        SpringHelper.injectBeans(context.getServletContext(), (Object)voIterator);
        return voIterator;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setElementService(ElementService elementService) {
        this.elementService = elementService;
    }
}

