/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.members.list;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.reports.members.list.MembersListReportDTO;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.reports.MembersReportVO;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountDateDTO;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.ads.AdService;
import nl.strohalm.cyclos.services.elements.ReferenceService;
import nl.strohalm.cyclos.utils.Period;

public class MembersListReportVOIterator
implements Iterator<MembersReportVO> {
    private final MembersListReportDTO dto;
    private final Collection<AccountType> accountTypes;
    private final Iterator<Member> membersIterator;
    private AdService adService;
    private ReferenceService referenceService;
    private AccountService accountService;

    MembersListReportVOIterator(MembersListReportDTO dto, Collection<AccountType> accountTypes, List<Member> members) {
        this.dto = dto;
        this.accountTypes = accountTypes;
        this.membersIterator = members.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.membersIterator.hasNext();
    }

    @Override
    public MembersReportVO next() {
        MembersReportVO membersReportVO = new MembersReportVO();
        Member member = this.membersIterator.next();
        membersReportVO.setMember(member);
        Period period = null;
        if (this.dto.getPeriod() != null) {
            period = Period.exact(this.dto.getPeriod());
            period.setUseTime(true);
        }
        if (this.dto.isAds()) {
            Map<Ad.Status, Integer> ads = this.adService.getNumberOfAds(period != null ? period.getEnd() : null, member);
            membersReportVO.setAds(ads);
        }
        if (this.dto.isGivenReferences()) {
            Map<Reference.Level, Integer> givenReferences = this.referenceService.countReferencesHistoryByLevel(Reference.Nature.GENERAL, member, period, false);
            membersReportVO.setGivenReferences(givenReferences);
        }
        if (this.dto.isReceivedReferences()) {
            Map<Reference.Level, Integer> receivedReferences = this.referenceService.countReferencesHistoryByLevel(Reference.Nature.GENERAL, member, period, true);
            membersReportVO.setReceivedReferences(receivedReferences);
        }
        if (this.dto.isAccountsInformation()) {
            HashMap<AccountType, BigDecimal> accountsCreditsMap = new HashMap<AccountType, BigDecimal>();
            HashMap<AccountType, BigDecimal> accountsUpperCreditsMap = new HashMap<AccountType, BigDecimal>();
            HashMap<AccountType, BigDecimal> accountsBalancesMap = new HashMap<AccountType, BigDecimal>();
            for (AccountType accountType : this.accountTypes) {
                AccountDTO accountDto = new AccountDTO();
                accountDto.setType(accountType);
                accountDto.setOwner(member);
                try {
                    Account account = this.accountService.getAccount(accountDto, null);
                    if (this.dto.isAccountsCredits()) {
                        BigDecimal creditLimit = account.getCreditLimit();
                        accountsCreditsMap.put(accountType, creditLimit);
                    }
                    if (this.dto.isAccountsUpperCredits()) {
                        BigDecimal upperCreditLimit = account.getUpperCreditLimit();
                        accountsUpperCreditsMap.put(accountType, upperCreditLimit);
                    }
                    if (!this.dto.isAccountsBalances()) continue;
                    BigDecimal balance = this.accountService.getBalance(new AccountDateDTO(account, this.dto.getPeriod()));
                    accountsBalancesMap.put(accountType, balance);
                }
                catch (EntityNotFoundException e) {}
            }
            membersReportVO.setAccountsCredits(accountsCreditsMap);
            membersReportVO.setAccountsUpperCredits(accountsUpperCreditsMap);
            membersReportVO.setAccountsBalances(accountsBalancesMap);
        }
        return membersReportVO;
    }

    @Override
    public void remove() {
    }

    @Inject
    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    @Inject
    public void setAdService(AdService adService) {
        this.adService = adService;
    }

    @Inject
    public void setReferenceService(ReferenceService referenceService) {
        this.referenceService = referenceService;
    }
}

