/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.members.sms;

import java.util.Collection;
import java.util.EnumSet;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.reports.members.sms.SmsLogsReportForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.entities.sms.SmsLog;
import nl.strohalm.cyclos.entities.sms.SmsLogReportQuery;
import nl.strohalm.cyclos.entities.sms.SmsLogReportVO;
import nl.strohalm.cyclos.entities.sms.SmsLogStatus;
import nl.strohalm.cyclos.entities.sms.SmsLogType;
import nl.strohalm.cyclos.entities.sms.SmsMailing;
import nl.strohalm.cyclos.entities.sms.SmsMailingType;
import nl.strohalm.cyclos.entities.sms.SmsType;
import nl.strohalm.cyclos.services.sms.SmsLogService;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SmsLogsReportAction
extends BaseQueryAction
implements LocalSettingsChangeListener {
    private DataBinder<SmsLogReportQuery> dataBinder;
    private SmsLogService smsLogService;

    public static DataBinder<SmsLogReportQuery> getSmsLogReportQueryBinder(LocalSettings settings) {
        BeanBinder<SmsLogReportQuery> binder = BeanBinder.instance(SmsLogReportQuery.class);
        binder.registerBinder("period", DataBinderHelper.periodBinder(settings, "period"));
        binder.registerBinder("memberGroups", SimpleCollectionBinder.instance(MemberGroup.class, "memberGroups"));
        binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
        binder.registerBinder("status", PropertyBinder.instance(SmsLogStatus.class, "status"));
        binder.registerBinder("type", PropertyBinder.instance(SmsLogType.class, "type"));
        binder.registerBinder("mailingTypes", SimpleCollectionBinder.instance(SmsMailingType.class, "mailingTypes"));
        binder.registerBinder("messageTypes", SimpleCollectionBinder.instance(Message.Type.class, "messageTypes"));
        binder.registerBinder("smsTypes", SimpleCollectionBinder.instance(SmsType.class, "smsTypes"));
        binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
        return binder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setSmsLogService(SmsLogService smsLogService) {
        this.smsLogService = smsLogService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        SmsLogReportQuery query = (SmsLogReportQuery)queryParameters.clone();
        SmsLogReportVO report = this.smsLogService.getSmsLogReport(query);
        request.setAttribute("totals", report.getTotals());
        request.setAttribute("totalsByType", report.getTotalsByType());
        request.setAttribute("totalsByStatus", report.getTotalsByStatus());
        request.setAttribute("total", (Object)report.getTotal());
        request.setAttribute("smsLogs", report.getLogs());
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        Administrator admin = (Administrator)this.elementService.load(((Entity)context.getElement()).getId(), RelationshipHelper.nested(Element.Relationships.GROUP, AdminGroup.Relationships.MANAGES_GROUPS));
        request.setAttribute("memberGroups", admin.getAdminGroup().getManagesGroups());
        RequestHelper.storeEnum(request, SmsLogType.class, "typesList");
        RequestHelper.storeEnum(request, SmsLogStatus.class, "statusList");
        RequestHelper.storeEnum(request, SmsMailingType.class, "mailingTypes");
        request.setAttribute("smsTypes", this.smsLogService.getSmsTypes());
        EnumSet<Message.Type> messageTypes = EnumSet.allOf(Message.Type.class);
        messageTypes.remove(Message.Type.FROM_MEMBER);
        messageTypes.remove(Message.Type.FROM_ADMIN_TO_GROUP);
        messageTypes.remove(Message.Type.FROM_ADMIN_TO_MEMBER);
        request.setAttribute("messagesTypes", messageTypes);
        SmsLogsReportForm form = (SmsLogsReportForm)((Object)context.getForm());
        SmsLogReportQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setReturnTotals(true);
        query.fetch(RelationshipHelper.nested(SmsLog.Relationships.TARGET_MEMBER, Element.Relationships.USER), RelationshipHelper.nested(SmsLog.Relationships.SMS_MAILING, SmsMailing.Relationships.BY));
        if (query.getMember() != null) {
            query.setMember((Member)this.elementService.load(query.getMember().getId(), Element.Relationships.USER));
        }
        Collection<MemberGroup> grps = this.groupService.load(EntityHelper.toIdsAsList(query.getMemberGroups()), new Relationship[0]);
        query.setMemberGroups(grps);
        query.setSmsTypes(this.smsLogService.loadSmsTypes(EntityHelper.toIdsAsList(query.getSmsTypes())));
        return query;
    }

    private DataBinder<SmsLogReportQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings settings = this.settingsService.getLocalSettings();
            this.dataBinder = SmsLogsReportAction.getSmsLogReportQueryBinder(settings);
        }
        return this.dataBinder;
    }
}

