/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.members.sms;

import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseCsvAction;
import nl.strohalm.cyclos.controls.reports.members.sms.SmsLogsReportAction;
import nl.strohalm.cyclos.controls.reports.members.sms.SmsLogsReportForm;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.entities.sms.SmsLog;
import nl.strohalm.cyclos.entities.sms.SmsLogReportQuery;
import nl.strohalm.cyclos.entities.sms.SmsMailing;
import nl.strohalm.cyclos.services.sms.SmsLogService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.csv.CSVWriter;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SmsLogsReportCsvAction
extends BaseCsvAction
implements LocalSettingsChangeListener {
    private SmsLogService smsLogService;
    private DataBinder<SmsLogReportQuery> dataBinder;

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setSmsLogService(SmsLogService smsLogService) {
        this.smsLogService = smsLogService;
    }

    protected List<?> executeQuery(ActionContext context) {
        SmsLogsReportForm form = (SmsLogsReportForm)((Object)context.getForm());
        SmsLogReportQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.fetch(SmsLog.Relationships.SMS_TYPE, RelationshipHelper.nested(SmsLog.Relationships.TARGET_MEMBER, Element.Relationships.USER), RelationshipHelper.nested(SmsLog.Relationships.SMS_MAILING, SmsMailing.Relationships.BY));
        return this.smsLogService.getSmsLogReport(query).getLogs();
    }

    @Override
    protected String fileName(ActionContext context) {
        return "sent_sms_report.csv";
    }

    protected CSVWriter resolveCSVWriter(ActionContext context) {
        LocalSettings settings = this.settingsService.getLocalSettings();
        CSVWriter<SmsLog> csv = CSVWriter.instance(SmsLog.class, settings);
        csv.addColumn(context.message("member.username", new Object[0]), "targetMember.username");
        csv.addColumn(context.message("member.name", new Object[0]), "targetMember.name");
        csv.addColumn(context.message("smsLog.date", new Object[0]), "date", settings.getDateTimeConverter());
        csv.addColumn(context.message("smsLog.type", new Object[0]), "type", this.messageHelper.getMessageConverter(this.getServlet().getServletContext(), "smsLog.type."));
        csv.addColumn(context.message("smsLog.mailingType", new Object[0]), "smsMailing.type", this.messageHelper.getMessageConverter(this.getServlet().getServletContext(), "smsMailing.mailingType."));
        csv.addColumn(context.message("smsLog.messageType", new Object[0]), "messageType", this.messageHelper.getMessageConverter(this.getServlet().getServletContext(), "message.type."));
        csv.addColumn(context.message("smsLog.smsType", new Object[0]), null, new SmsTypeConverter());
        csv.addColumn(context.message("smsLog.free", new Object[0]), "free", this.messageHelper.getBooleanConverter(this.getServlet().getServletContext()));
        csv.addColumn(context.message("smsLog.status", new Object[0]), "status", this.messageHelper.getMessageConverter(this.getServlet().getServletContext(), "smsLog.status."));
        return csv;
    }

    private DataBinder<SmsLogReportQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings settings = this.settingsService.getLocalSettings();
            this.dataBinder = SmsLogsReportAction.getSmsLogReportQueryBinder(settings);
        }
        return this.dataBinder;
    }

    private class SmsTypeConverter
    implements Converter<SmsLog> {
        private static final long serialVersionUID = 1L;

        private SmsTypeConverter() {
        }

        @Override
        public String toString(SmsLog smsLog) {
            if (smsLog.getSmsType() != null) {
                return SmsLogsReportCsvAction.this.messageHelper.message("sms.type." + smsLog.getSmsType().getCode() + ".description", smsLog.getArg0(), smsLog.getArg1(), smsLog.getArg2(), smsLog.getArg3(), smsLog.getArg4());
            }
            return null;
        }

        @Override
        public SmsLog valueOf(String string) {
            throw new UnsupportedOperationException("SmsLog from String not supported");
        }
    }
}

