/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.members.transactions;

import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseCsvAction;
import nl.strohalm.cyclos.controls.reports.members.transactions.MembersReportHandler;
import nl.strohalm.cyclos.controls.reports.members.transactions.MembersTransactionsReportDTO;
import nl.strohalm.cyclos.controls.reports.members.transactions.MembersTransactionsReportForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.members.MemberTransactionDetailsReportData;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.transfertypes.PaymentFilterService;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.IteratorListImpl;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.csv.CSVWriter;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;

public class ExportMembersTransactionsDetailsToCsvAction
extends BaseCsvAction {
    private MembersReportHandler reportHandler;
    private PaymentFilterService paymentFilterService;

    public MembersReportHandler getReportHandler() {
        if (this.reportHandler == null) {
            this.reportHandler = new MembersReportHandler(this.settingsService.getLocalSettings());
            SpringHelper.injectBeans(this.getServlet().getServletContext(), (Object)this.reportHandler);
        }
        return this.reportHandler;
    }

    @Inject
    public void setPaymentFilterService(PaymentFilterService paymentFilterService) {
        this.paymentFilterService = paymentFilterService;
    }

    protected List<?> executeQuery(ActionContext context) {
        MembersReportHandler reportHandler = this.getReportHandler();
        Pair<MembersTransactionsReportDTO, Iterator<MemberTransactionDetailsReportData>> pair = reportHandler.handleTransactionsDetails(context);
        final MembersTransactionsReportDTO dto = pair.getFirst();
        Iterator<MemberTransactionDetailsReportData> reportIterator = pair.getSecond();
        Iterator iterator = IteratorUtils.filteredIterator(reportIterator, (Predicate)new Predicate(){

            public boolean evaluate(Object element) {
                MemberTransactionDetailsReportData data = (MemberTransactionDetailsReportData)element;
                if (dto.isIncludeNoTraders()) {
                    return true;
                }
                return data.getAmount() != null;
            }
        });
        return new IteratorListImpl(iterator);
    }

    @Override
    protected String fileName(ActionContext context) {
        return "members_transactions_details_" + ((User)context.getUser()).getUsername() + ".csv";
    }

    @Override
    protected CSVWriter<?> resolveCSVWriter(ActionContext context) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        MembersTransactionsReportForm form = (MembersTransactionsReportForm)((Object)context.getForm());
        MembersTransactionsReportDTO dto = this.getReportHandler().getDataBinder().readFromString(form.getMembersTransactionsReport());
        dto.setTransactionsPaymentFilters(this.paymentFilterService.load(EntityHelper.toIdsAsList(dto.getTransactionsPaymentFilters()), new Relationship[0]));
        this.responseHelper.setDownload(context.getResponse(), "members_transactions_details.csv");
        CSVWriter<MemberTransactionDetailsReportData> csv = CSVWriter.instance(MemberTransactionDetailsReportData.class, localSettings);
        csv.addColumn(context.message("member.username", new Object[0]), "username");
        if (dto.isMemberName()) {
            csv.addColumn(context.message("member.name", new Object[0]), "name");
        }
        if (dto.isBrokerUsername()) {
            csv.addColumn(context.message("member.brokerUsername", new Object[0]), "brokerUsername");
        }
        if (dto.isBrokerName()) {
            csv.addColumn(context.message("member.brokerName", new Object[0]), "brokerName");
        }
        csv.addColumn(context.message("account.type", new Object[0]), "accountTypeName");
        csv.addColumn(context.message("transfer.type", new Object[0]), "transferTypeName");
        csv.addColumn(context.message("transfer.date", new Object[0]), "date", localSettings.getDateConverter());
        csv.addColumn(context.message("transfer.amount", new Object[0]), "amount", localSettings.getNumberConverter());
        csv.addColumn(context.message("transfer.fromOrTo", new Object[0]), "relatedUsername");
        if (dto.isMemberName()) {
            csv.addColumn(context.message("transfer.fromOrTo", new Object[0]), "relatedName");
        }
        if (localSettings.getTransactionNumber() != null && localSettings.getTransactionNumber().isValid()) {
            csv.addColumn(context.message("transfer.transactionNumber", new Object[0]), "transactionNumber");
        }
        csv.addColumn(context.message("transfer.description", new Object[0]), "description");
        return csv;
    }
}

