/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.members.transactions;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseCsvAction;
import nl.strohalm.cyclos.controls.reports.members.transactions.MembersReportHandler;
import nl.strohalm.cyclos.controls.reports.members.transactions.MembersTransactionsReportDTO;
import nl.strohalm.cyclos.controls.reports.members.transactions.MembersTransactionsReportForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.members.MemberTransactionSummaryReportData;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.services.transfertypes.PaymentFilterService;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.IteratorListImpl;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.conversion.Converter;
import nl.strohalm.cyclos.utils.csv.CSVWriter;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;

public class ExportMembersTransactionsReportToCsvAction
extends BaseCsvAction {
    private MembersReportHandler reportHandler;
    private PaymentFilterService paymentFilterService;

    public MembersReportHandler getReportHandler() {
        if (this.reportHandler == null) {
            this.reportHandler = new MembersReportHandler(this.settingsService.getLocalSettings());
            SpringHelper.injectBeans(this.getServlet().getServletContext(), (Object)this.reportHandler);
        }
        return this.reportHandler;
    }

    @Inject
    public void setPaymentFilterService(PaymentFilterService paymentFilterService) {
        this.paymentFilterService = paymentFilterService;
    }

    protected List<?> executeQuery(ActionContext context) {
        MembersReportHandler reportHandler = this.getReportHandler();
        Pair<MembersTransactionsReportDTO, Iterator<MemberTransactionSummaryReportData>> pair = reportHandler.handleTransactionsSummary(context);
        final MembersTransactionsReportDTO dto = pair.getFirst();
        Iterator<MemberTransactionSummaryReportData> reportIterator = pair.getSecond();
        Iterator iterator = IteratorUtils.filteredIterator(reportIterator, (Predicate)new Predicate(){

            public boolean evaluate(Object element) {
                MemberTransactionSummaryReportData data = (MemberTransactionSummaryReportData)element;
                if (dto.isIncludeNoTraders()) {
                    return true;
                }
                return data.isHasData();
            }
        });
        return new IteratorListImpl(iterator);
    }

    @Override
    protected String fileName(ActionContext context) {
        Object loggedUser = context.getUser();
        return "members_transactions_summaries_" + ((User)loggedUser).getUsername() + ".csv";
    }

    protected CSVWriter<MemberTransactionSummaryReportData> resolveCSVWriter(ActionContext context) {
        MembersTransactionsReportForm form = (MembersTransactionsReportForm)((Object)context.getForm());
        MembersTransactionsReportDTO dto = this.getReportHandler().getDataBinder().readFromString(form.getMembersTransactionsReport());
        dto.setTransactionsPaymentFilters(this.paymentFilterService.load(EntityHelper.toIdsAsList(dto.getTransactionsPaymentFilters()), new Relationship[0]));
        LocalSettings settings = this.settingsService.getLocalSettings();
        CSVWriter<MemberTransactionSummaryReportData> csv = CSVWriter.instance(MemberTransactionSummaryReportData.class, settings);
        csv.addColumn(context.message("member.username", new Object[0]), "member.username");
        if (dto.isMemberName()) {
            csv.addColumn(context.message("member.name", new Object[0]), "member.name");
        }
        if (dto.isBrokerUsername()) {
            csv.addColumn(context.message("member.brokerUsername", new Object[0]), "member.broker.username");
        }
        if (dto.isBrokerName()) {
            csv.addColumn(context.message("member.brokerName", new Object[0]), "member.broker.name");
        }
        Collection<PaymentFilter> transactionsPaymentFilters = dto.getTransactionsPaymentFilters();
        boolean incomingTransactions = dto.isIncomingTransactions();
        boolean outgoingTransactions = dto.isOutgoingTransactions();
        for (PaymentFilter paymentFilter : transactionsPaymentFilters) {
            if (incomingTransactions) {
                csv.addColumn(context.message("reports.transactions_report.transactions", paymentFilter.getName(), context.message("reports.transactions_report.number", new Object[0]), context.message("reports.transactions_report.credits", new Object[0])), "credits", new SummaryByPaymentFilterConverter(paymentFilter, true));
                csv.addColumn(context.message("reports.transactions_report.transactions", paymentFilter.getName(), context.message("reports.transactions_report.amount", new Object[0]), context.message("reports.transactions_report.credits", new Object[0])), "credits", new SummaryByPaymentFilterConverter(paymentFilter, false));
            }
            if (!outgoingTransactions) continue;
            csv.addColumn(context.message("reports.transactions_report.transactions", paymentFilter.getName(), context.message("reports.transactions_report.number", new Object[0]), context.message("reports.transactions_report.debits", new Object[0])), "debits", new SummaryByPaymentFilterConverter(paymentFilter, true));
            csv.addColumn(context.message("reports.transactions_report.transactions", paymentFilter.getName(), context.message("reports.transactions_report.amount", new Object[0]), context.message("reports.transactions_report.debits", new Object[0])), "debits", new SummaryByPaymentFilterConverter(paymentFilter, false));
        }
        return csv;
    }

    class TransactionSummaryVOConverter
    implements Converter<TransactionSummaryVO> {
        private static final long serialVersionUID = -3481170993171107591L;
        private final boolean isCount;

        TransactionSummaryVOConverter(boolean isCount) {
            this.isCount = isCount;
        }

        @Override
        public String toString(TransactionSummaryVO vo) {
            String string = "";
            if (vo != null) {
                if (this.isCount) {
                    int count = vo.getCount();
                    string = "" + count;
                } else {
                    BigDecimal amount = vo.getAmount();
                    string = ExportMembersTransactionsReportToCsvAction.this.settingsService.getLocalSettings().getNumberConverter().toString(amount);
                }
            }
            return string;
        }

        @Override
        public TransactionSummaryVO valueOf(String string) {
            return null;
        }
    }

    class SummaryByPaymentFilterConverter
    implements Converter<Map<PaymentFilter, TransactionSummaryVO>> {
        private static final long serialVersionUID = -4821798713533063020L;
        private final PaymentFilter paymentFilter;
        private final boolean isCount;

        SummaryByPaymentFilterConverter(PaymentFilter paymentFilter, boolean isCount) {
            this.paymentFilter = paymentFilter;
            this.isCount = isCount;
        }

        @Override
        public String toString(Map<PaymentFilter, TransactionSummaryVO> map) {
            String string = "";
            TransactionSummaryVO vo = map.get(this.paymentFilter);
            if (vo != null) {
                if (this.isCount) {
                    int count = vo.getCount();
                    string = "" + count;
                } else {
                    BigDecimal amount = vo.getAmount();
                    string = ExportMembersTransactionsReportToCsvAction.this.settingsService.getLocalSettings().getNumberConverter().toString(amount);
                }
            }
            return string;
        }

        @Override
        public Map<PaymentFilter, TransactionSummaryVO> valueOf(String string) {
            return null;
        }
    }
}

