/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.members.transactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.reports.members.transactions.MembersTransactionsReportDTO;
import nl.strohalm.cyclos.controls.reports.members.transactions.MembersTransactionsReportForm;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.MemberTransactionDetailsReportData;
import nl.strohalm.cyclos.entities.members.MemberTransactionSummaryReportData;
import nl.strohalm.cyclos.entities.members.MembersTransactionsReportParameters;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.transfertypes.PaymentFilterService;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;

public class MembersReportHandler {
    private AccountService accountService;
    private AccountTypeService accountTypeService;
    private PaymentFilterService paymentFilterService;
    private BeanBinder<MembersTransactionsReportDTO> binder;
    private LocalSettings settings = null;

    public MembersReportHandler(LocalSettings settings) {
        this.settings = settings;
    }

    public BeanBinder<MembersTransactionsReportDTO> getDataBinder() {
        if (this.binder == null) {
            ReferenceConverter<AccountType> accountTypeConverter = ReferenceConverter.instance(AccountType.class);
            ReferenceConverter<PaymentFilter> paymentFilterConverter = ReferenceConverter.instance(PaymentFilter.class);
            ReferenceConverter<MemberGroup> memberGroupConverter = ReferenceConverter.instance(MemberGroup.class);
            BeanBinder<MembersTransactionsReportDTO> temp = BeanBinder.instance(MembersTransactionsReportDTO.class);
            temp.registerBinder("memberName", PropertyBinder.instance(Boolean.TYPE, "memberName"));
            temp.registerBinder("brokerUsername", PropertyBinder.instance(Boolean.TYPE, "brokerUsername"));
            temp.registerBinder("brokerName", PropertyBinder.instance(Boolean.TYPE, "brokerName"));
            temp.registerBinder("accountTypes", SimpleCollectionBinder.instance(AccountType.class, "accountTypes", accountTypeConverter));
            temp.registerBinder("memberGroups", SimpleCollectionBinder.instance(MemberGroup.class, "memberGroups", memberGroupConverter));
            temp.registerBinder("period", DataBinderHelper.periodBinder(this.settings, "period"));
            temp.registerBinder("transactionsPaymentFilters", SimpleCollectionBinder.instance(PaymentFilter.class, "transactionsPaymentFilters", paymentFilterConverter));
            temp.registerBinder("incomingTransactions", PropertyBinder.instance(Boolean.TYPE, "incomingTransactions"));
            temp.registerBinder("outgoingTransactions", PropertyBinder.instance(Boolean.TYPE, "outgoingTransactions"));
            temp.registerBinder("includeNoTraders", PropertyBinder.instance(Boolean.TYPE, "includeNoTraders"));
            temp.registerBinder("detailsLevel", PropertyBinder.instance(MembersTransactionsReportDTO.DetailsLevel.class, "detailsLevel"));
            this.binder = temp;
        }
        return this.binder;
    }

    public Pair<MembersTransactionsReportDTO, Iterator<MemberTransactionDetailsReportData>> handleTransactionsDetails(ActionContext context) {
        MembersTransactionsReportDTO dto = this.readDTO(context);
        MembersTransactionsReportParameters params = this.toTransactionReportParameters(dto);
        Iterator<MemberTransactionDetailsReportData> iterator = this.accountService.membersTransactionsDetailsReport(params);
        return new Pair<MembersTransactionsReportDTO, Iterator<MemberTransactionDetailsReportData>>(dto, iterator);
    }

    public Pair<MembersTransactionsReportDTO, Iterator<MemberTransactionSummaryReportData>> handleTransactionsSummary(ActionContext context) {
        MembersTransactionsReportDTO dto = this.readDTO(context);
        MembersTransactionsReportParameters params = this.toTransactionReportParameters(dto);
        params.setPageParameters(new PageParameters(-1, 0));
        Iterator<MemberTransactionSummaryReportData> iterator = this.accountService.membersTransactionsSummaryReport(params);
        return new Pair<MembersTransactionsReportDTO, Iterator<MemberTransactionSummaryReportData>>(dto, iterator);
    }

    @Inject
    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setPaymentFilterService(PaymentFilterService paymentFilterService) {
        this.paymentFilterService = paymentFilterService;
    }

    public void validateDTO(MembersTransactionsReportDTO dto) throws ValidationException {
        this.adjustDto(dto);
        ValidationException validationException = new ValidationException();
        if (CollectionUtils.isEmpty(dto.getMemberGroups())) {
            validationException.addGeneralError(new ValidationError("reports.members_reports.transactions.memberGroupsRequired", new Object[0]));
        }
        if (CollectionUtils.isEmpty(dto.getAccountTypes())) {
            validationException.addGeneralError(new ValidationError("reports.members_reports.transactions.accountTypesRequired", new Object[0]));
        }
        if (dto.getDetailsLevel() == MembersTransactionsReportDTO.DetailsLevel.SUMMARY) {
            if (CollectionUtils.isEmpty(dto.getTransactionsPaymentFilters())) {
                validationException.addGeneralError(new ValidationError("reports.members_reports.transactions.paymentFilterRequired", new Object[0]));
            } else if (!dto.isIncomingTransactions() && !dto.isOutgoingTransactions()) {
                validationException.addGeneralError(new ValidationError("reports.members_reports.transactions.transactionModeRequired", new Object[0]));
            }
        }
        validationException.throwIfHasErrors();
    }

    private void adjustDto(MembersTransactionsReportDTO dto) {
        Collection<AccountType> accountTypes = this.accountTypeService.load(EntityHelper.toIdsAsList(dto.getAccountTypes()));
        dto.setAccountTypes(accountTypes);
        Collection<PaymentFilter> transactionsPaymentFilters = this.paymentFilterService.load(EntityHelper.toIdsAsList(dto.getTransactionsPaymentFilters()), PaymentFilter.Relationships.ACCOUNT_TYPE);
        HashMap<AccountType, Collection<PaymentFilter>> paymentFiltersByAccountType = new HashMap<AccountType, Collection<PaymentFilter>>();
        for (AccountType accountType : accountTypes) {
            ArrayList<PaymentFilter> accountTypePaymentFilters = new ArrayList<PaymentFilter>();
            for (PaymentFilter paymentFilter : transactionsPaymentFilters) {
                if (!paymentFilter.getAccountType().equals(accountType)) continue;
                accountTypePaymentFilters.add(paymentFilter);
            }
            paymentFiltersByAccountType.put(accountType, accountTypePaymentFilters);
        }
        dto.setPaymentFiltersByAccountType(paymentFiltersByAccountType);
        HashMap<PaymentFilter, Integer> transactionsColSpan = new HashMap<PaymentFilter, Integer>();
        boolean incomingTransactions = dto.isIncomingTransactions();
        boolean outgoingTransactions = dto.isOutgoingTransactions();
        if (incomingTransactions || outgoingTransactions) {
            Iterator<PaymentFilter> it = transactionsPaymentFilters.iterator();
            while (it.hasNext()) {
                PaymentFilter paymentFilter;
                paymentFilter = it.next();
                int colSpan = 0;
                if (incomingTransactions) {
                    colSpan += 2;
                }
                if (outgoingTransactions) {
                    colSpan += 2;
                }
                if (colSpan == 0) {
                    it.remove();
                    continue;
                }
                transactionsColSpan.put(paymentFilter, colSpan);
            }
        }
        dto.setTransactionsPaymentFilters(transactionsPaymentFilters);
        dto.setTransactionsColSpan(transactionsColSpan);
    }

    private MembersTransactionsReportDTO readDTO(ActionContext context) {
        MembersTransactionsReportForm form = (MembersTransactionsReportForm)((Object)context.getForm());
        MembersTransactionsReportDTO dto = this.getDataBinder().readFromString(form.getMembersTransactionsReport());
        dto.setTransactionsPaymentFilters(this.paymentFilterService.load(EntityHelper.toIdsAsList(dto.getTransactionsPaymentFilters()), PaymentFilter.Relationships.TRANSFER_TYPES));
        this.adjustDto(dto);
        return dto;
    }

    private MembersTransactionsReportParameters toTransactionReportParameters(MembersTransactionsReportDTO dto) {
        MembersTransactionsReportParameters params = new MembersTransactionsReportParameters();
        params.setFetchBroker(dto.isBrokerName() || dto.isBrokerUsername());
        params.setMemberGroups(dto.getMemberGroups());
        params.setPeriod(dto.getPeriod());
        params.setCredits(dto.isIncomingTransactions());
        params.setDebits(dto.isOutgoingTransactions());
        Map<AccountType, Collection<PaymentFilter>> paymentFiltersByAccountType = dto.getPaymentFiltersByAccountType();
        if (paymentFiltersByAccountType != null) {
            HashSet<PaymentFilter> allPaymentFilters = new HashSet<PaymentFilter>();
            for (Collection<PaymentFilter> paymentFilters : paymentFiltersByAccountType.values()) {
                allPaymentFilters.addAll(paymentFilters);
            }
            params.setPaymentFilters(allPaymentFilters);
        }
        return params;
    }
}

