/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.members.transactions;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.reports.members.transactions.MembersReportHandler;
import nl.strohalm.cyclos.controls.reports.members.transactions.MembersTransactionsReportDTO;
import nl.strohalm.cyclos.controls.reports.members.transactions.MembersTransactionsReportForm;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.MemberTransactionSummaryReportData;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.NamedPeriod;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class MembersTransactionsReportAction
extends BaseFormAction {
    private MembersReportHandler reportHandler;

    public MembersReportHandler getReportHandler() {
        if (this.reportHandler == null) {
            this.reportHandler = new MembersReportHandler(this.settingsService.getLocalSettings());
            SpringHelper.injectBeans(this.getServlet().getServletContext(), (Object)this.reportHandler);
        }
        return this.reportHandler;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        Pair<MembersTransactionsReportDTO, Iterator<MemberTransactionSummaryReportData>> pair = this.getReportHandler().handleTransactionsSummary(context);
        MembersTransactionsReportDTO dto = pair.getFirst();
        if (dto.getDetailsLevel() != MembersTransactionsReportDTO.DetailsLevel.SUMMARY) {
            throw new ValidationException();
        }
        request.setAttribute("iterator", pair.getSecond());
        request.setAttribute("dto", (Object)dto);
    }

    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        MembersTransactionsReportForm form = (MembersTransactionsReportForm)((Object)context.getForm());
        NamedPeriod period = NamedPeriod.getLastQuarterPeriod();
        LocalSettings settings = this.settingsService.getLocalSettings();
        BeanBinder<Period> periodBinder = DataBinderHelper.periodBinder(settings, "period");
        periodBinder.writeAsString(form.getMembersTransactionsReport(), period);
        AdminGroup adminGroup = (AdminGroup)context.getGroup();
        adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.MANAGES_GROUPS);
        TreeSet<MemberGroup> groups = new TreeSet<MemberGroup>(adminGroup.getManagesGroups());
        request.setAttribute("memberGroups", groups);
        RequestHelper.storeEnum(request, MembersTransactionsReportDTO.DetailsLevel.class, "detailsLevels");
        return context.getInputForward();
    }

    @Override
    protected void validateForm(ActionContext context) {
        MembersTransactionsReportForm form = (MembersTransactionsReportForm)((Object)context.getForm());
        Map<String, Object> membersTransactionsReport = form.getMembersTransactionsReport();
        MembersReportHandler handler = this.getReportHandler();
        BeanBinder<MembersTransactionsReportDTO> dataBinder = handler.getDataBinder();
        MembersTransactionsReportDTO dto = dataBinder.readFromString(membersTransactionsReport);
        handler.validateDTO(dto);
    }
}

