/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.members.transactions;

import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.utils.DataObject;
import nl.strohalm.cyclos.utils.Period;

public class MembersTransactionsReportDTO
extends DataObject {
    private static final long serialVersionUID = -5856820625601506756L;
    private boolean memberName;
    private boolean brokerUsername;
    private boolean brokerName;
    private Collection<AccountType> accountTypes;
    private Collection<MemberGroup> memberGroups;
    private Period period;
    private boolean incomingTransactions;
    private boolean outgoingTransactions;
    private boolean includeNoTraders;
    private DetailsLevel detailsLevel;
    private Collection<PaymentFilter> transactionsPaymentFilters;
    private Map<PaymentFilter, Integer> transactionsColSpan;
    private Map<AccountType, Collection<PaymentFilter>> paymentFiltersByAccountType;

    public Collection<AccountType> getAccountTypes() {
        return this.accountTypes;
    }

    public int getBrokerColSpan() {
        int colspan = 0;
        if (this.isBrokerName()) {
            ++colspan;
        }
        if (this.isBrokerUsername()) {
            ++colspan;
        }
        return colspan;
    }

    public DetailsLevel getDetailsLevel() {
        return this.detailsLevel;
    }

    public int getMemberColSpan() {
        if (this.isMemberName()) {
            return 2;
        }
        return 1;
    }

    public Collection<MemberGroup> getMemberGroups() {
        return this.memberGroups;
    }

    public Map<AccountType, Collection<PaymentFilter>> getPaymentFiltersByAccountType() {
        return this.paymentFiltersByAccountType;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Map<PaymentFilter, Integer> getTransactionsColSpan() {
        return this.transactionsColSpan;
    }

    public Collection<PaymentFilter> getTransactionsPaymentFilters() {
        return this.transactionsPaymentFilters;
    }

    public boolean isBrokerName() {
        return this.brokerName;
    }

    public boolean isBrokerUsername() {
        return this.brokerUsername;
    }

    public boolean isDebitsAndCredits() {
        return this.isIncomingTransactions() && this.isOutgoingTransactions();
    }

    public boolean isIncludeNoTraders() {
        return this.includeNoTraders;
    }

    public boolean isIncomingTransactions() {
        return this.incomingTransactions;
    }

    public boolean isMemberName() {
        return this.memberName;
    }

    public boolean isOutgoingTransactions() {
        return this.outgoingTransactions;
    }

    public boolean isTransactions() {
        return this.isIncomingTransactions() || this.isOutgoingTransactions();
    }

    public void setAccountTypes(Collection<AccountType> accountTypes) {
        this.accountTypes = accountTypes;
    }

    public void setBrokerName(boolean brokerName) {
        this.brokerName = brokerName;
    }

    public void setBrokerUsername(boolean brokerUsername) {
        this.brokerUsername = brokerUsername;
    }

    public void setDetailsLevel(DetailsLevel detailsLevel) {
        this.detailsLevel = detailsLevel;
    }

    public void setIncludeNoTraders(boolean includeNoTraders) {
        this.includeNoTraders = includeNoTraders;
    }

    public void setIncomingTransactions(boolean incomingTransactions) {
        this.incomingTransactions = incomingTransactions;
    }

    public void setMemberGroups(Collection<MemberGroup> memberGroups) {
        this.memberGroups = memberGroups;
    }

    public void setMemberName(boolean memberName) {
        this.memberName = memberName;
    }

    public void setOutgoingTransactions(boolean outgoingTransactions) {
        this.outgoingTransactions = outgoingTransactions;
    }

    public void setPaymentFiltersByAccountType(Map<AccountType, Collection<PaymentFilter>> paymentFiltersByAccountType) {
        this.paymentFiltersByAccountType = paymentFiltersByAccountType;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public void setTransactionsColSpan(Map<PaymentFilter, Integer> transactionsColSpan) {
        this.transactionsColSpan = transactionsColSpan;
    }

    public void setTransactionsPaymentFilters(Collection<PaymentFilter> transactionsPaymentFilters) {
        this.transactionsPaymentFilters = transactionsPaymentFilters;
    }

    public static enum DetailsLevel {
        SUMMARY,
        TRANSACTIONS;

    }
}

