/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.simulations;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.reports.simulations.RateConfigSimulationForm;
import nl.strohalm.cyclos.controls.reports.statistics.graphs.StatisticalDataProducer;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.SimpleTransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.rates.ARatedFeeDTO;
import nl.strohalm.cyclos.services.accounts.rates.RateService;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import org.apache.struts.action.ActionForward;

public class ARateConfigSimulationAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private DataBinder<ARatedFeeDTO> dataBinder;
    private TransferTypeService transferTypeService;
    private RateService rateService;
    private TransactionFeeService transactionFeeService;

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dataBinder = null;
    }

    @Inject
    public void setRateService(RateService rateService) {
        this.rateService = rateService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        RateConfigSimulationForm form = (RateConfigSimulationForm)((Object)context.getForm());
        if (form.isReloadData()) {
            return this.handleDisplay(context);
        }
        ARatedFeeDTO dto = this.getDataBinder().readFromString(form.getSimulation());
        ArrayList<StatisticalDataProducer> dataList = new ArrayList<StatisticalDataProducer>();
        StatisticalResultDTO rawDataObject = this.rateService.getRateConfigGraph(dto);
        StatisticalDataProducer producer = new StatisticalDataProducer(rawDataObject, context);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        producer.setSettings(localSettings);
        dataList.add(producer);
        request.setAttribute("dataList", dataList);
        this.prepareForm(context);
        return context.getInputForward();
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        SimpleTransactionFee.ARateRelation arateRelation;
        boolean firstTime;
        RateConfigSimulationForm form = (RateConfigSimulationForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        ARatedFeeDTO dto = this.getDataBinder().readFromString(form.getSimulation());
        EnumSet<TransactionFee.ChargeType> chargeTypes = EnumSet.of(TransactionFee.ChargeType.A_RATE, TransactionFee.ChargeType.MIXED_A_D_RATES);
        request.setAttribute("chargeTypes", chargeTypes);
        RequestHelper.storeEnum(request, SimpleTransactionFee.ARateRelation.class, "aRateRelations");
        List<TransferType> aRatedTTs = this.transferTypeService.listARatedTTs();
        TransferType tt = dto.getTransferType();
        boolean bl = firstTime = tt == null;
        if (tt == null && aRatedTTs.size() > 0) {
            tt = aRatedTTs.get(0);
        }
        if (tt != null) {
            tt = this.transferTypeService.load(tt.getId(), TransferType.Relationships.TRANSACTION_FEES);
        }
        Collection<Object> fees = tt == null ? Collections.emptyList() : tt.getARatedFees();
        SimpleTransactionFee.ARateRelation aRateRelation = arateRelation = dto.getfInfinite() == null ? SimpleTransactionFee.ARateRelation.LINEAR : SimpleTransactionFee.ARateRelation.ASYMPTOTICAL;
        if (arateRelation == null) {
            arateRelation = SimpleTransactionFee.ARateRelation.LINEAR;
        }
        if (dto.getChargeType() == null) {
            dto.setChargeType(TransactionFee.ChargeType.A_RATE);
        }
        if (tt != null && (firstTime || form.isReloadData())) {
            TransactionFee fee = dto.getTransactionFee();
            if (fee != null) {
                fee = this.transactionFeeService.load(fee.getId(), TransactionFee.Relationships.ORIGINAL_TRANSFER_TYPE);
            }
            if (fee == null || !fee.getOriginalTransferType().equals(tt)) {
                fee = (TransactionFee)fees.get(0);
            }
            if (fee != null && fee instanceof SimpleTransactionFee) {
                SimpleTransactionFee simpleFee = (SimpleTransactionFee)fee;
                dto.setChargeType(fee.getChargeType());
                arateRelation = simpleFee.getfInfinite() == null ? SimpleTransactionFee.ARateRelation.LINEAR : SimpleTransactionFee.ARateRelation.ASYMPTOTICAL;
                dto.setH(simpleFee.getH());
                dto.setaFIsZero(simpleFee.getaFIsZero());
                dto.setF1(simpleFee.getF1());
                dto.setfInfinite(simpleFee.getfInfinite());
                dto.setfMinimal(simpleFee.getfMinimal());
                dto.setgFIsZero(simpleFee.getgFIsZero());
            }
        }
        if (firstTime) {
            dto.setRangeStart(0);
            dto.setRangeEnd(arateRelation == SimpleTransactionFee.ARateRelation.ASYMPTOTICAL ? 100 : 30);
        }
        dto.setTransferType(tt);
        form.setSimulation("aRateRelation", arateRelation.name());
        this.getDataBinder().writeAsString(form.getSimulation(), dto);
        request.setAttribute("tts", aRatedTTs);
        if (aRatedTTs.size() == 1) {
            request.setAttribute("singleTT", (Object)"true");
        }
        request.setAttribute("fees", fees);
        if (fees.size() == 1) {
            request.setAttribute("singleFee", (Object)"true");
        }
        request.setAttribute("simulation", (Object)"true");
    }

    @Override
    protected void validateForm(ActionContext context) {
        RateConfigSimulationForm form = (RateConfigSimulationForm)((Object)context.getForm());
        ARatedFeeDTO dto = this.getDataBinder().readFromString(form.getSimulation());
        SimpleTransactionFee.ARateRelation aRateRelation = PropertyBinder.instance(SimpleTransactionFee.ARateRelation.class, "aRateRelation").readFromString(form.getSimulation());
        this.rateService.validate(dto, aRateRelation);
    }

    private DataBinder<ARatedFeeDTO> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<ARatedFeeDTO> binder = BeanBinder.instance(ARatedFeeDTO.class);
            binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferType"));
            binder.registerBinder("transactionFee", PropertyBinder.instance(TransactionFee.class, "transactionFee"));
            binder.registerBinder("chargeType", PropertyBinder.instance(TransactionFee.ChargeType.class, "chargeType"));
            binder.registerBinder("h", PropertyBinder.instance(BigDecimal.class, "h", localSettings.getHighPrecisionConverter()));
            binder.registerBinder("aFIsZero", PropertyBinder.instance(BigDecimal.class, "aFIsZero", localSettings.getHighPrecisionConverter()));
            binder.registerBinder("f1", PropertyBinder.instance(BigDecimal.class, "f1", localSettings.getHighPrecisionConverter()));
            binder.registerBinder("fInfinite", PropertyBinder.instance(BigDecimal.class, "fInfinite", localSettings.getHighPrecisionConverter()));
            binder.registerBinder("fMinimal", PropertyBinder.instance(BigDecimal.class, "fMinimal", localSettings.getHighPrecisionConverter()));
            binder.registerBinder("gFIsZero", PropertyBinder.instance(BigDecimal.class, "gFIsZero", localSettings.getHighPrecisionConverter()));
            binder.registerBinder("rangeStart", PropertyBinder.instance(Integer.class, "rangeStart"));
            binder.registerBinder("rangeEnd", PropertyBinder.instance(Integer.class, "rangeEnd"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

