/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.simulations;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.reports.simulations.RateConfigSimulationForm;
import nl.strohalm.cyclos.controls.reports.statistics.graphs.StatisticalDataProducer;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.accounts.rates.DRatedFeeDTO;
import nl.strohalm.cyclos.services.accounts.rates.RateService;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import org.apache.struts.action.ActionForward;

public class DRateConfigSimulationAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private DataBinder<DRatedFeeDTO> dataBinder;
    private RateService rateService;
    private CurrencyService currencyService;

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dataBinder = null;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Inject
    public void setRateService(RateService rateService) {
        this.rateService = rateService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        RateConfigSimulationForm form = (RateConfigSimulationForm)((Object)context.getForm());
        if (form.isReloadData()) {
            return this.handleDisplay(context);
        }
        this.prepareForm(context);
        DRatedFeeDTO dto = this.getDataBinder().readFromString(form.getSimulation());
        ArrayList<StatisticalDataProducer> dataList = new ArrayList<StatisticalDataProducer>();
        StatisticalResultDTO rawDataObject = this.rateService.getRateConfigGraph(dto);
        StatisticalDataProducer producer = new StatisticalDataProducer(rawDataObject, context);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        producer.setSettings(localSettings);
        dataList.add(producer);
        request.setAttribute("dataList", dataList);
        return context.getInputForward();
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        boolean firstTime;
        RateConfigSimulationForm form = (RateConfigSimulationForm)((Object)context.getForm());
        DRatedFeeDTO dto = this.getDataBinder().readFromString(form.getSimulation());
        List<Currency> ratedCurrencies = this.currencyService.listDRatedCurrencies();
        Currency currency = dto.getCurrency();
        boolean bl = firstTime = currency == null;
        if (currency == null && ratedCurrencies.size() > 0) {
            currency = ratedCurrencies.get(0);
        }
        if (currency != null && (firstTime || form.isReloadData())) {
            currency = this.currencyService.load(currency.getId());
            BigDecimal interest = currency.getdRateParameters().getInterest();
            BigDecimal baseMalus = currency.getdRateParameters().getBaseMalus();
            BigDecimal minimalD = currency.getMinimalD();
            dto.setCurrency(currency);
            dto.setInterest(interest);
            dto.setBaseMalus(baseMalus);
            dto.setMinimalD(minimalD);
            dto.setRangeStart(30);
            dto.setRangeEnd(0);
        }
        this.getDataBinder().writeAsString(form.getSimulation(), dto);
        HttpServletRequest request = context.getRequest();
        request.setAttribute("currencies", ratedCurrencies);
        if (ratedCurrencies.size() == 1) {
            request.setAttribute("singleCurrency", (Object)"true");
        }
    }

    @Override
    protected void validateForm(ActionContext context) {
        RateConfigSimulationForm form = (RateConfigSimulationForm)((Object)context.getForm());
        DRatedFeeDTO dto = this.getDataBinder().readFromString(form.getSimulation());
        this.rateService.validate(dto, null);
    }

    private DataBinder<DRatedFeeDTO> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            BeanBinder<DRatedFeeDTO> binder = BeanBinder.instance(DRatedFeeDTO.class);
            binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currency"));
            binder.registerBinder("interest", PropertyBinder.instance(BigDecimal.class, "interest", localSettings.getHighPrecisionConverter()));
            binder.registerBinder("baseMalus", PropertyBinder.instance(BigDecimal.class, "baseMalus", localSettings.getNumberConverter()));
            binder.registerBinder("minimalD", PropertyBinder.instance(BigDecimal.class, "minimalD", localSettings.getNumberConverter()));
            binder.registerBinder("rangeStart", PropertyBinder.instance(Integer.class, "rangeStart"));
            binder.registerBinder("rangeEnd", PropertyBinder.instance(Integer.class, "rangeEnd"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

