/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.statistics;

import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.reports.statistics.StatisticsForm;
import nl.strohalm.cyclos.controls.reports.statistics.graphs.StatisticalDataProducer;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilterQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupFilterQuery;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.reports.StatisticalQuery;
import nl.strohalm.cyclos.entities.reports.StatisticsWhatToShow;
import nl.strohalm.cyclos.entities.reports.ThroughTimeRange;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.SystemAccountTypeQuery;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.services.stats.StatisticalService;
import nl.strohalm.cyclos.services.transfertypes.PaymentFilterService;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Month;
import nl.strohalm.cyclos.utils.NamedPeriod;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.Quarter;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.collections.CollectionUtils;

public abstract class StatisticsAction
extends BaseQueryAction
implements LocalSettingsChangeListener {
    private StatisticalService statisticalService;
    private PaymentFilterService paymentFilterService;
    private AccountTypeService accountTypeService;
    private GroupFilterService groupFilterService;
    private DataBinder<? extends StatisticalQuery> dataBinder;

    protected static void bindCommonFields(BeanBinder<? extends StatisticalQuery> binder, LocalSettings settings) {
        binder.registerBinder("periodMain", DataBinderHelper.namedPeriodBinder(settings, "periodMain"));
        binder.registerBinder("periodComparedTo", DataBinderHelper.namedPeriodBinder(settings, "periodComparedTo"));
        binder.registerBinder("throughTimeRange", PropertyBinder.instance(ThroughTimeRange.class, "throughTimeRange"));
        binder.registerBinder("initialMonth", PropertyBinder.instance(Month.class, "initialMonth"));
        binder.registerBinder("finalMonth", PropertyBinder.instance(Month.class, "finalMonth"));
        binder.registerBinder("initialQuarter", PropertyBinder.instance(Quarter.class, "initialQuarter"));
        binder.registerBinder("finalQuarter", PropertyBinder.instance(Quarter.class, "finalQuarter"));
        binder.registerBinder("initialYear", PropertyBinder.instance(Integer.class, "initialYear"));
        binder.registerBinder("initialMonthYear", PropertyBinder.instance(Integer.class, "initialMonthYear"));
        binder.registerBinder("initialQuarterYear", PropertyBinder.instance(Integer.class, "initialQuarterYear"));
        binder.registerBinder("finalYear", PropertyBinder.instance(Integer.class, "finalYear"));
        binder.registerBinder("finalMonthYear", PropertyBinder.instance(Integer.class, "finalMonthYear"));
        binder.registerBinder("finalQuarterYear", PropertyBinder.instance(Integer.class, "finalQuarterYear"));
        binder.registerBinder("paymentFilter", PropertyBinder.instance(PaymentFilter.class, "paymentFilter", ReferenceConverter.instance(PaymentFilter.class)));
        binder.registerBinder("paymentFilters", SimpleCollectionBinder.instance(PaymentFilter.class, "paymentFilters", ReferenceConverter.instance(PaymentFilter.class)));
        binder.registerBinder("groupFilters", SimpleCollectionBinder.instance(GroupFilter.class, "groupFilters"));
        binder.registerBinder("groups", SimpleCollectionBinder.instance(Group.class, "groups"));
        binder.registerBinder("systemAccountFilter", PropertyBinder.instance(SystemAccountType.class, "systemAccountFilter"));
        binder.registerBinder("whatToShow", PropertyBinder.instance(StatisticsWhatToShow.class, "whatToShow"));
    }

    public DataBinder<? extends StatisticalQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings settings = this.settingsService.getLocalSettings();
            this.dataBinder = this.initDataBinder(settings);
        }
        return this.dataBinder;
    }

    public abstract StatisticsType getStatisticsType();

    public abstract DataBinder<? extends StatisticalQuery> initDataBinder(LocalSettings var1);

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Inject
    public void setPaymentFilterService(PaymentFilterService paymentFilterService) {
        this.paymentFilterService = paymentFilterService;
    }

    protected void applyGroupFilter(HttpServletRequest request) {
        GroupQuery groupQuery = new GroupQuery();
        groupQuery.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
        request.setAttribute("groups", this.groupService.search(groupQuery));
        GroupFilterQuery groupFilterQuery = new GroupFilterQuery();
        List<GroupFilter> groupFilters = this.groupFilterService.search(groupFilterQuery);
        if (CollectionUtils.isNotEmpty(groupFilters)) {
            request.setAttribute("groupFilters", groupFilters);
        }
    }

    protected void applyPaymentFilter(HttpServletRequest request) {
        PaymentFilterQuery pfQuery = new PaymentFilterQuery();
        pfQuery.setContext(PaymentFilterQuery.Context.REPORT);
        List<PaymentFilter> paymentFilters = this.paymentFilterService.search(pfQuery);
        request.setAttribute("paymentFilterList", paymentFilters);
    }

    protected void applySystemAccountFilter(HttpServletRequest request) {
        List<? extends AccountType> systemAccounts = this.accountTypeService.search(new SystemAccountTypeQuery());
        request.setAttribute("systemAccounts", systemAccounts);
    }

    protected void bindPeriods(StatisticalQuery query, StatisticsForm form) {
        if (query.getPeriodMain().getEnd() == null) {
            NamedPeriod periodMain = NamedPeriod.getLastQuarterPeriod();
            NamedPeriod periodComparedTo = periodMain.getOneYearEarlier();
            this.bindPeriod("periodMain", form, periodMain);
            this.bindPeriod("periodComparedTo", form, periodComparedTo);
        }
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        StatisticalQuery query = (StatisticalQuery)queryParameters;
        HttpServletRequest request = context.getRequest();
        request.setAttribute("statisticsType", (Object)this.getStatisticsType());
        if (query.getWhatToShow() == StatisticsWhatToShow.THROUGH_TIME) {
            ThroughTimeRange throughTimeRange = query.getThroughTimeRange();
            Period period = this.getPeriodByTimeRange(query);
            Period[] periods = DateHelper.getPeriodsThroughTheTime(period, throughTimeRange);
            query.setPeriods(periods);
        }
        Collection<GroupFilter> groupFilters = query.getGroupFilters();
        boolean hasGroupFilters = CollectionUtils.isNotEmpty(groupFilters);
        boolean hasGroups = CollectionUtils.isNotEmpty(query.getGroups());
        if (hasGroupFilters && !hasGroups) {
            HashSet<Group> groupsFromFilters = new HashSet<Group>();
            if (hasGroupFilters) {
                for (GroupFilter groupFilter : groupFilters) {
                    groupFilter = this.groupFilterService.load(groupFilter.getId(), GroupFilter.Relationships.GROUPS);
                    groupsFromFilters.addAll(groupFilter.getGroups());
                }
                query.setGroups(groupsFromFilters);
            }
        }
    }

    protected StatisticalService getBaseStatisticalService() {
        return this.statisticalService;
    }

    protected Period getPeriodByTimeRange(StatisticalQuery queryParameters) {
        ThroughTimeRange throughTimeRange = queryParameters.getThroughTimeRange();
        GregorianCalendar calendarBegin = null;
        GregorianCalendar calendarEnd = null;
        if (throughTimeRange == ThroughTimeRange.MONTH) {
            calendarBegin = new GregorianCalendar(queryParameters.getInitialMonthYear(), queryParameters.getInitialMonth().getValue(), 1);
            GregorianCalendar calendarEndAux = new GregorianCalendar(queryParameters.getFinalMonthYear(), queryParameters.getFinalMonth().getValue(), 1);
            calendarEnd = new GregorianCalendar(queryParameters.getFinalMonthYear(), queryParameters.getFinalMonth().getValue(), ((Calendar)calendarEndAux).getActualMaximum(5), 23, 59, 59);
        } else if (throughTimeRange == ThroughTimeRange.QUARTER) {
            Quarter initialQuarter = queryParameters.getInitialQuarter();
            Quarter finalQuarter = queryParameters.getFinalQuarter();
            calendarBegin = new GregorianCalendar(queryParameters.getInitialQuarterYear(), initialQuarter.getValue() * 3 - 3, 1);
            GregorianCalendar calendarEndAux = new GregorianCalendar(queryParameters.getFinalQuarterYear(), finalQuarter.getValue() * 3 - 3, 1);
            calendarEnd = new GregorianCalendar(queryParameters.getFinalQuarterYear(), finalQuarter.getValue() * 3 - 3, ((Calendar)calendarEndAux).getActualMaximum(5), 23, 59, 59);
        } else if (throughTimeRange == ThroughTimeRange.YEAR) {
            calendarBegin = new GregorianCalendar(queryParameters.getInitialYear(), 0, 1);
            calendarEnd = new GregorianCalendar(queryParameters.getFinalYear(), 11, 31, 23, 59, 59);
        }
        Period period = new Period(calendarBegin, calendarEnd);
        return period;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        StatisticsForm form = (StatisticsForm)((Object)context.getForm());
        StatisticalQuery query = this.getDataBinder().readFromString(form.getQuery());
        this.bindPeriods(query, form);
        HttpServletRequest request = context.getRequest();
        RequestHelper.storeEnum(request, StatisticsWhatToShow.class, "whatToShow");
        RequestHelper.storeEnum(request, ThroughTimeRange.class, "throughTimeRange");
        RequestHelper.storeEnum(request, Month.class, "months");
        RequestHelper.storeEnum(request, Quarter.class, "quarters");
        if (form.getQuery("throughTimeRange") == null) {
            form.setQuery("throughTimeRange", (Object)ThroughTimeRange.MONTH);
        }
        if (form.getQuery("initialMonth") == null) {
            Map<String, Object> completedMonthAndYear = DateHelper.getLastCompletedMonthAndYear();
            int lastCompletedMonth = (Integer)completedMonthAndYear.get("month");
            int lastCompletedMonthYear = (Integer)completedMonthAndYear.get("year");
            form.setQuery("initialMonth", lastCompletedMonth);
            form.setQuery("initialMonthYear", lastCompletedMonthYear - 1);
            form.setQuery("finalMonth", lastCompletedMonth);
            form.setQuery("finalMonthYear", lastCompletedMonthYear);
        }
        if (form.getQuery("initialQuarter") == null) {
            Map<String, Object> completedQuarterAndYear = DateHelper.getLastCompletedQuarterAndYear();
            Quarter lastCompletedQuarter = (Quarter)completedQuarterAndYear.get("quarter");
            int lastCompletedQuarterYear = (Integer)completedQuarterAndYear.get("year");
            form.setQuery("initialQuarter", lastCompletedQuarter);
            form.setQuery("initialQuarterYear", lastCompletedQuarterYear - 1);
            form.setQuery("finalQuarter", lastCompletedQuarter);
            form.setQuery("finalQuarterYear", lastCompletedQuarterYear);
        }
        if (form.getQuery("initialYear") == null) {
            int currentYear;
            int lastYear;
            Calendar date = this.elementService.getFirstMemberActivationDate();
            int firstYear = 0;
            firstYear = date != null ? date.get(1) : Calendar.getInstance().get(1);
            if (firstYear > (lastYear = (currentYear = Calendar.getInstance().get(1)) - 1)) {
                firstYear = currentYear;
                lastYear = currentYear;
            }
            form.setQuery("initialYear", firstYear);
            form.setQuery("finalYear", lastYear);
        }
        return query;
    }

    protected StatisticalDataProducer producerFactory(StatisticalResultDTO rawDataObject, ActionContext context, Class producerClass) {
        Class[] argumentClasses = new Class[]{StatisticalResultDTO.class, ActionContext.class};
        Object[] constructorArguments = new Object[]{rawDataObject, context};
        Constructor producerConstructor = null;
        StatisticalDataProducer producer = null;
        try {
            producerConstructor = producerClass.getConstructor(argumentClasses);
            producer = (StatisticalDataProducer)producerConstructor.newInstance(constructorArguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            producer = new StatisticalDataProducer(rawDataObject, context);
        }
        LocalSettings settings = this.settingsService.getLocalSettings();
        if (producer != null) {
            producer.setSettings(settings);
        }
        return producer;
    }

    protected TransferTypeQuery resolveTransferTypeQuery(ActionContext context) {
        return null;
    }

    protected void setStatisticalService(StatisticalService statisticalService) {
        this.statisticalService = statisticalService;
    }

    @Override
    protected void validateForm(ActionContext context) {
        StatisticsForm form = (StatisticsForm)((Object)context.getForm());
        StatisticalQuery query = this.getDataBinder().readFromString(form.getQuery());
        this.statisticalService.validate(query);
    }

    private void bindPeriod(String name, StatisticsForm form, NamedPeriod period) {
        LocalSettings settings = this.settingsService.getLocalSettings();
        BeanBinder<NamedPeriod> periodBinder = DataBinderHelper.namedPeriodBinder(settings, name);
        periodBinder.writeAsString(form.getQuery(), period);
    }

    public static enum StatisticsType {
        KEY_DEVELOPMENTS,
        MEMBER_ACTIVITIES,
        FINANCES,
        TAXES;

    }
}

