/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.statistics;

import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.reports.statistics.StatisticsAction;
import nl.strohalm.cyclos.controls.reports.statistics.graphs.StatisticalDataProducer;
import nl.strohalm.cyclos.entities.reports.StatisticalActivityQuery;
import nl.strohalm.cyclos.entities.reports.StatisticsWhatToShow;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.services.stats.StatisticalActivityService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class StatisticsActivityAction
extends StatisticsAction
implements LocalSettingsChangeListener {
    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        super.executeQuery(context, queryParameters);
        StatisticalActivityQuery query = (StatisticalActivityQuery)queryParameters;
        ArrayList<StatisticalDataProducer> dataList = new ArrayList<StatisticalDataProducer>();
        if (query.getWhatToShow() == StatisticsWhatToShow.SINGLE_PERIOD) {
            if (query.isGrossProduct()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodGrossProduct(query), context, StatisticalDataProducer.class));
            }
            if (query.isNumberTransactions()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodNumberTransactions(query), context, StatisticalDataProducer.class));
            }
            if (query.isPercentageNoTrade()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodPercentageNoTrade(query), context, StatisticalDataProducer.class));
            }
            if (query.isLoginTimes()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodLoginTimes(query), context, StatisticalDataProducer.class));
            }
        } else if (query.getWhatToShow() == StatisticsWhatToShow.COMPARE_PERIODS) {
            if (query.isGrossProduct()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsGrossProduct(query), context, StatisticalDataProducer.class));
            }
            if (query.isNumberTransactions()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsNumberTransactions(query), context, StatisticalDataProducer.class));
            }
            if (query.isPercentageNoTrade()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsPercentageNoTrade(query), context, StatisticalDataProducer.class));
            }
            if (query.isLoginTimes()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsLoginTimes(query), context, StatisticalDataProducer.class));
            }
        } else if (query.getWhatToShow() == StatisticsWhatToShow.THROUGH_TIME) {
            if (query.isGrossProduct()) {
                dataList.add(this.producerFactory(this.getService().getThroughTheTimeGrossProduct(query), context, StatisticalDataProducer.class));
            }
            if (query.isNumberTransactions()) {
                dataList.add(this.producerFactory(this.getService().getThroughTheTimeNumberTransactions(query), context, StatisticalDataProducer.class));
            }
            if (query.isPercentageNoTrade()) {
                dataList.add(this.producerFactory(this.getService().getThroughTheTimePercentageNoTrade(query), context, StatisticalDataProducer.class));
            }
            if (query.isLoginTimes()) {
                dataList.add(this.producerFactory(this.getService().getThroughTheTimeLoginTimes(query), context, StatisticalDataProducer.class));
            }
        } else {
            if (query.isGrossProduct()) {
                dataList.add(this.producerFactory(this.getService().getHistogramGrossProduct(query), context, StatisticalDataProducer.class));
            }
            if (query.isNumberTransactions()) {
                dataList.add(this.producerFactory(this.getService().getHistogramNumberTransactions(query), context, StatisticalDataProducer.class));
            }
            if (query.isLoginTimes()) {
                dataList.add(this.producerFactory(this.getService().getHistogramLoginTimes(query), context, StatisticalDataProducer.class));
            }
            if (query.isGrossProductTopten()) {
                dataList.add(this.producerFactory(this.getService().getToptenPersonalGrossProduct(query), context, StatisticalDataProducer.class));
            }
            if (query.isNumberTransactionsTopten()) {
                dataList.add(this.producerFactory(this.getService().getToptenPersonalNumberTransactions(query), context, StatisticalDataProducer.class));
            }
            if (query.isLoginTimesTopten()) {
                dataList.add(this.producerFactory(this.getService().getToptenPersonalLoginTimes(query), context, StatisticalDataProducer.class));
            }
        }
        HttpServletRequest request = context.getRequest();
        request.setAttribute("dataList", dataList);
    }

    private StatisticalActivityService getService() {
        return (StatisticalActivityService)this.getBaseStatisticalService();
    }

    @Override
    public StatisticsAction.StatisticsType getStatisticsType() {
        return StatisticsAction.StatisticsType.MEMBER_ACTIVITIES;
    }

    public DataBinder<StatisticalActivityQuery> initDataBinder(LocalSettings settings) {
        BeanBinder<StatisticalActivityQuery> binder = BeanBinder.instance(StatisticalActivityQuery.class);
        StatisticsAction.bindCommonFields(binder, settings);
        binder.registerBinder("grossProduct", PropertyBinder.instance(Boolean.TYPE, "grossProduct"));
        binder.registerBinder("grossProductGraph", PropertyBinder.instance(Boolean.TYPE, "grossProductGraph"));
        binder.registerBinder("grossProductTopten", PropertyBinder.instance(Boolean.TYPE, "grossProductTopten"));
        binder.registerBinder("numberTransactions", PropertyBinder.instance(Boolean.TYPE, "numberTransactions"));
        binder.registerBinder("numberTransactionsGraph", PropertyBinder.instance(Boolean.TYPE, "numberTransactionsGraph"));
        binder.registerBinder("numberTransactionsTopten", PropertyBinder.instance(Boolean.TYPE, "numberTransactionsTopten"));
        binder.registerBinder("percentageNoTrade", PropertyBinder.instance(Boolean.TYPE, "percentageNoTrade"));
        binder.registerBinder("percentageNoTradeGraph", PropertyBinder.instance(Boolean.TYPE, "percentageNoTradeGraph"));
        binder.registerBinder("loginTimes", PropertyBinder.instance(Boolean.TYPE, "loginTimes"));
        binder.registerBinder("loginTimesGraph", PropertyBinder.instance(Boolean.TYPE, "loginTimesGraph"));
        binder.registerBinder("loginTimesTopten", PropertyBinder.instance(Boolean.TYPE, "loginTimesTopten"));
        return binder;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        this.applyGroupFilter(request);
        this.applyPaymentFilter(request);
        QueryParameters queryParameters = super.prepareForm(context);
        request.setAttribute("whatToShow", Arrays.asList(StatisticsWhatToShow.SINGLE_PERIOD, StatisticsWhatToShow.COMPARE_PERIODS, StatisticsWhatToShow.THROUGH_TIME, StatisticsWhatToShow.DISTRIBUTION));
        this.getService().setMaximumDataPoints(150);
        return queryParameters;
    }

    @Inject
    public void setStatisticalActivityService(StatisticalActivityService statisticalService) {
        this.setStatisticalService(statisticalService);
    }
}

