/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.statistics;

import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.reports.statistics.StatisticsAction;
import nl.strohalm.cyclos.controls.reports.statistics.graphs.StatisticalDataProducer;
import nl.strohalm.cyclos.entities.reports.StatisticalFinancesQuery;
import nl.strohalm.cyclos.entities.reports.StatisticsWhatToShow;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.stats.StatisticalFinancesService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class StatisticsFinancesAction
extends StatisticsAction {
    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        super.executeQuery(context, queryParameters);
        StatisticalFinancesQuery query = (StatisticalFinancesQuery)queryParameters;
        ArrayList<StatisticalDataProducer> dataList = new ArrayList<StatisticalDataProducer>();
        if (query.getWhatToShow() == StatisticsWhatToShow.SINGLE_PERIOD) {
            if (query.isOverview()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodOverview(query), context, StatisticalDataProducer.class));
            }
            if (query.isIncome()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodIncome(query), context, StatisticalDataProducer.class));
            }
            if (query.isExpenditure()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodExpenditure(query), context, StatisticalDataProducer.class));
            }
        } else if (query.getWhatToShow() == StatisticsWhatToShow.COMPARE_PERIODS) {
            if (query.isIncome()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsIncome(query), context, StatisticalDataProducer.class));
            }
            if (query.isExpenditure()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsExpenditure(query), context, StatisticalDataProducer.class));
            }
        } else if (query.getWhatToShow() == StatisticsWhatToShow.THROUGH_TIME) {
            if (query.isIncome()) {
                dataList.add(this.producerFactory(this.getService().getThroughTimeIncome(query), context, StatisticalDataProducer.class));
            }
            if (query.isExpenditure()) {
                dataList.add(this.producerFactory(this.getService().getThroughTimeExpenditure(query), context, StatisticalDataProducer.class));
            }
        }
        HttpServletRequest request = context.getRequest();
        request.setAttribute("dataList", dataList);
    }

    private StatisticalFinancesService getService() {
        return (StatisticalFinancesService)this.getBaseStatisticalService();
    }

    @Override
    public StatisticsAction.StatisticsType getStatisticsType() {
        return StatisticsAction.StatisticsType.FINANCES;
    }

    public DataBinder<StatisticalFinancesQuery> initDataBinder(LocalSettings settings) {
        BeanBinder<StatisticalFinancesQuery> binder = BeanBinder.instance(StatisticalFinancesQuery.class);
        StatisticsAction.bindCommonFields(binder, settings);
        binder.registerBinder("overview", PropertyBinder.instance(Boolean.TYPE, "overview"));
        binder.registerBinder("income", PropertyBinder.instance(Boolean.TYPE, "income"));
        binder.registerBinder("expenditure", PropertyBinder.instance(Boolean.TYPE, "expenditure"));
        binder.registerBinder("overviewGraph", PropertyBinder.instance(Boolean.TYPE, "overviewGraph"));
        binder.registerBinder("incomeGraph", PropertyBinder.instance(Boolean.TYPE, "incomeGraph"));
        binder.registerBinder("expenditureGraph", PropertyBinder.instance(Boolean.TYPE, "expenditureGraph"));
        return binder;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        this.applySystemAccountFilter(request);
        this.applyPaymentFilter(request);
        QueryParameters queryParameters = super.prepareForm(context);
        request.setAttribute("whatToShow", Arrays.asList(StatisticsWhatToShow.SINGLE_PERIOD, StatisticsWhatToShow.COMPARE_PERIODS, StatisticsWhatToShow.THROUGH_TIME));
        this.getService().setMaximumDataPoints(300);
        return queryParameters;
    }

    @Inject
    public void setStatisticalFinancesService(StatisticalFinancesService statisticalService) {
        this.setStatisticalService(statisticalService);
    }
}

