/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.statistics;

import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.reports.statistics.StatisticsAction;
import nl.strohalm.cyclos.controls.reports.statistics.graphs.StatisticalDataProducer;
import nl.strohalm.cyclos.entities.reports.StatisticalKeyDevelopmentsQuery;
import nl.strohalm.cyclos.entities.reports.StatisticsWhatToShow;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.stats.StatisticalKeyDevelopmentsService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class StatisticsKeyDevelopmentsAction
extends StatisticsAction {
    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        super.executeQuery(context, queryParameters);
        StatisticalKeyDevelopmentsQuery query = (StatisticalKeyDevelopmentsQuery)queryParameters;
        ArrayList<StatisticalDataProducer> dataList = new ArrayList<StatisticalDataProducer>();
        if (query.getWhatToShow() == StatisticsWhatToShow.SINGLE_PERIOD) {
            if (query.isNumberOfMembers()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodNumberOfMembers(query), context, StatisticalDataProducer.class));
            }
            if (query.isGrossProduct()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodGrossProduct(query), context, StatisticalDataProducer.class));
            }
            if (query.isNumberOfTransactions()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodNumberOfTransactions(query), context, StatisticalDataProducer.class));
            }
            if (query.isTransactionAmount()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodMedianAmountPerTransaction(query), context, StatisticalDataProducer.class));
                dataList.add(this.producerFactory(this.getService().getSinglePeriodHighestTransactionAmount(query), context, StatisticalDataProducer.class));
            }
            if (query.isNumberOfAds()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodNumberOfAds(query), context, StatisticalDataProducer.class));
            }
        } else if (query.getWhatToShow() == StatisticsWhatToShow.COMPARE_PERIODS) {
            if (query.isNumberOfMembers()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsNumberOfMembers(query), context, StatisticalDataProducer.class));
            }
            if (query.isGrossProduct()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsGrossProduct(query), context, StatisticalDataProducer.class));
            }
            if (query.isNumberOfTransactions()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsNumberOfTransactions(query), context, StatisticalDataProducer.class));
            }
            if (query.isTransactionAmount()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsMedianAmountPerTransaction(query), context, StatisticalDataProducer.class));
                dataList.add(this.producerFactory(this.getService().getComparePeriodsHighestTransactionAmount(query), context, StatisticalDataProducer.class));
            }
            if (query.isNumberOfAds()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsNumberOfAds(query), context, StatisticalDataProducer.class));
            }
        } else {
            dataList.add(this.producerFactory(this.getService().getThroughTheTime(query), context, StatisticalDataProducer.class));
        }
        HttpServletRequest request = context.getRequest();
        request.setAttribute("dataList", dataList);
    }

    private StatisticalKeyDevelopmentsService getService() {
        return (StatisticalKeyDevelopmentsService)this.getBaseStatisticalService();
    }

    @Override
    public StatisticsAction.StatisticsType getStatisticsType() {
        return StatisticsAction.StatisticsType.KEY_DEVELOPMENTS;
    }

    public DataBinder<StatisticalKeyDevelopmentsQuery> initDataBinder(LocalSettings settings) {
        BeanBinder<StatisticalKeyDevelopmentsQuery> binder = BeanBinder.instance(StatisticalKeyDevelopmentsQuery.class);
        StatisticsAction.bindCommonFields(binder, settings);
        binder.registerBinder("numberOfMembers", PropertyBinder.instance(Boolean.TYPE, "numberOfMembers"));
        binder.registerBinder("grossProduct", PropertyBinder.instance(Boolean.TYPE, "grossProduct"));
        binder.registerBinder("numberOfTransactions", PropertyBinder.instance(Boolean.TYPE, "numberOfTransactions"));
        binder.registerBinder("transactionAmount", PropertyBinder.instance(Boolean.TYPE, "transactionAmount"));
        binder.registerBinder("numberOfAds", PropertyBinder.instance(Boolean.TYPE, "numberOfAds"));
        binder.registerBinder("numberOfMembersGraph", PropertyBinder.instance(Boolean.TYPE, "numberOfMembersGraph"));
        binder.registerBinder("grossProductGraph", PropertyBinder.instance(Boolean.TYPE, "grossProductGraph"));
        binder.registerBinder("numberOfTransactionsGraph", PropertyBinder.instance(Boolean.TYPE, "numberOfTransactionsGraph"));
        binder.registerBinder("transactionAmountGraph", PropertyBinder.instance(Boolean.TYPE, "transactionAmountGraph"));
        binder.registerBinder("numberOfAdsGraph", PropertyBinder.instance(Boolean.TYPE, "numberOfAdsGraph"));
        binder.registerBinder("thruTimeGraph", PropertyBinder.instance(Boolean.TYPE, "thruTimeGraph"));
        return binder;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        this.applyGroupFilter(request);
        this.applyPaymentFilter(request);
        QueryParameters queryParameters = super.prepareForm(context);
        request.setAttribute("whatToShow", Arrays.asList(StatisticsWhatToShow.SINGLE_PERIOD, StatisticsWhatToShow.COMPARE_PERIODS, StatisticsWhatToShow.THROUGH_TIME));
        this.getService().setMaximumDataPoints(250);
        return queryParameters;
    }

    @Inject
    public void setStatisticalKeyDevelopmentsService(StatisticalKeyDevelopmentsService statisticalService) {
        this.setStatisticalService(statisticalService);
    }
}

