/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.statistics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.reports.statistics.StatisticsAction;
import nl.strohalm.cyclos.controls.reports.statistics.graphs.StatisticalDataProducer;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeQuery;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFeeQuery;
import nl.strohalm.cyclos.entities.reports.StatisticalTaxesQuery;
import nl.strohalm.cyclos.entities.reports.StatisticsWhatToShow;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accountfees.AccountFeeService;
import nl.strohalm.cyclos.services.stats.StatisticalTaxesService;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class StatisticsTaxesAction
extends StatisticsAction {
    private AccountFeeService accountFeeService;
    private TransactionFeeService transactionFeeService;

    @Override
    public StatisticsAction.StatisticsType getStatisticsType() {
        return StatisticsAction.StatisticsType.TAXES;
    }

    public DataBinder<StatisticalTaxesQuery> initDataBinder(LocalSettings settings) {
        BeanBinder<StatisticalTaxesQuery> binder = BeanBinder.instance(StatisticalTaxesQuery.class);
        StatisticsAction.bindCommonFields(binder, settings);
        binder.registerBinder("volume", PropertyBinder.instance(Boolean.TYPE, "volume"));
        binder.registerBinder("numberOfMembers", PropertyBinder.instance(Boolean.TYPE, "numberOfMembers"));
        binder.registerBinder("medianPerMember", PropertyBinder.instance(Boolean.TYPE, "medianPerMember"));
        binder.registerBinder("maxMember", PropertyBinder.instance(Boolean.TYPE, "maxMember"));
        binder.registerBinder("relativeToGrossProduct", PropertyBinder.instance(Boolean.TYPE, "relativeToGrossProduct"));
        binder.registerBinder("paidOrNot", PropertyBinder.instance(StatisticalTaxesService.PaidOrNot.class, "paidOrNot"));
        binder.registerBinder("notPaidLimit", PropertyBinder.instance(Integer.TYPE, "notPaidLimit"));
        binder.registerBinder("accountFees", SimpleCollectionBinder.instance(AccountFee.class, "accountFees", ReferenceConverter.instance(AccountFee.class)));
        binder.registerBinder("transactionFees", SimpleCollectionBinder.instance(TransactionFee.class, "transactionFees", ReferenceConverter.instance(TransactionFee.class)));
        return binder;
    }

    @Inject
    public void setAccountFeeService(AccountFeeService accountFeeService) {
        this.accountFeeService = accountFeeService;
    }

    @Inject
    public void setStatisticalTaxesService(StatisticalTaxesService statisticalService) {
        this.setStatisticalService(statisticalService);
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    protected void applyFeeFilters(HttpServletRequest request) {
        AccountFeeQuery accountFeeQuery = new AccountFeeQuery();
        accountFeeQuery.setReturnDisabled(false);
        List<AccountFee> accountFees = this.accountFeeService.search(accountFeeQuery);
        request.setAttribute("accountFeeList", accountFees);
        TransactionFeeQuery transactionFeeQuery = new TransactionFeeQuery();
        transactionFeeQuery.setReturnDisabled(false);
        List<? extends TransactionFee> transactionFees = this.transactionFeeService.search(transactionFeeQuery);
        request.setAttribute("transactionFeeList", transactionFees);
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        super.executeQuery(context, queryParameters);
        StatisticalTaxesQuery query = (StatisticalTaxesQuery)queryParameters;
        ArrayList<StatisticalDataProducer> dataList = new ArrayList<StatisticalDataProducer>();
        if (query.getWhatToShow() == StatisticsWhatToShow.SINGLE_PERIOD) {
            if (query.isVolume()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodVolume(query), context, StatisticalDataProducer.class));
            }
            if (query.isNumberOfMembers()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodNumberOfMembers(query), context, StatisticalDataProducer.class));
            }
            if (query.isMedianPerMember()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodMedianPerMember(query), context, StatisticalDataProducer.class));
            }
            if (query.isMaxMember()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodMaxMember(query), context, StatisticalDataProducer.class));
            }
            if (query.isRelativeToGrossProduct()) {
                dataList.add(this.producerFactory(this.getService().getSinglePeriodRelativeToGrossProduct(query), context, StatisticalDataProducer.class));
            }
        } else if (query.getWhatToShow() == StatisticsWhatToShow.COMPARE_PERIODS) {
            if (query.isVolume()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsVolume(query), context, StatisticalDataProducer.class));
            }
            if (query.isNumberOfMembers()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsNumberOfMembers(query), context, StatisticalDataProducer.class));
            }
            if (query.isMedianPerMember()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsMedianPerMember(query), context, StatisticalDataProducer.class));
            }
            if (query.isMaxMember()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsMaxMember(query), context, StatisticalDataProducer.class));
            }
            if (query.isRelativeToGrossProduct()) {
                dataList.add(this.producerFactory(this.getService().getComparePeriodsRelativeToGrossProduct(query), context, StatisticalDataProducer.class));
            }
        } else if (query.getWhatToShow() == StatisticsWhatToShow.THROUGH_TIME) {
            if (query.isVolume()) {
                dataList.add(this.producerFactory(this.getService().getThroughTimeVolume(query), context, StatisticalDataProducer.class));
            }
            if (query.isNumberOfMembers()) {
                dataList.add(this.producerFactory(this.getService().getThroughTimeNumberOfMembers(query), context, StatisticalDataProducer.class));
            }
            if (query.isMedianPerMember()) {
                dataList.add(this.producerFactory(this.getService().getThroughTimeMedianPerMember(query), context, StatisticalDataProducer.class));
            }
            if (query.isMaxMember()) {
                dataList.add(this.producerFactory(this.getService().getThroughTimeMaxMember(query), context, StatisticalDataProducer.class));
            }
            if (query.isRelativeToGrossProduct()) {
                dataList.add(this.producerFactory(this.getService().getThroughTimeRelativeToGrossProduct(query), context, StatisticalDataProducer.class));
            }
        } else if (query.getWhatToShow() == StatisticsWhatToShow.DISTRIBUTION) {
            if (query.isMedianPerMember()) {
                dataList.add(this.producerFactory(this.getService().getDistributionMedianPerMember(query), context, StatisticalDataProducer.class));
            }
            if (query.isRelativeToGrossProduct()) {
                dataList.add(this.producerFactory(this.getService().getDistributionRelativeToGrossProduct(query), context, StatisticalDataProducer.class));
            }
        }
        HttpServletRequest request = context.getRequest();
        request.setAttribute("dataList", dataList);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        RequestHelper.storeEnum(request, StatisticalTaxesService.PaidOrNot.class, "paidOrNot");
        this.applyGroupFilter(request);
        this.applyFeeFilters(request);
        QueryParameters queryParameters = super.prepareForm(context);
        request.setAttribute("whatToShow", Arrays.asList(StatisticsWhatToShow.SINGLE_PERIOD, StatisticsWhatToShow.COMPARE_PERIODS, StatisticsWhatToShow.THROUGH_TIME, StatisticsWhatToShow.DISTRIBUTION));
        return queryParameters;
    }

    private StatisticalTaxesService getService() {
        return (StatisticalTaxesService)this.getBaseStatisticalService();
    }
}

