/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.statistics.graphs;

import de.laures.cewolf.ChartPostProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.Map;
import nl.strohalm.cyclos.utils.jfreeAsymmetric.AsymmetricStatisticalBarRenderer;
import nl.strohalm.cyclos.utils.jfreeAsymmetric.AsymmetricStatisticalCategoryDataset;
import nl.strohalm.cyclos.utils.jfreeAsymmetric.AsymmetricStatisticalLineAndShapeRenderer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryMarker;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public final class ChartPostProcessorImpl
implements ChartPostProcessor {
    private static final int ROTATE_XLABELS_IF_MORE_THAN = 10;
    private final Color[] colorRange = new Color[]{Color.BLUE, Color.RED, new Color(65280), Color.MAGENTA, Color.YELLOW, Color.CYAN, new Color(32768), new Color(0x800000), new Color(128), new Color(0x800080), new Color(0x808000), new Color(32896), new Color(0x808080), new Color(0), new Color(0xFFFFFF), new Color(0xC0C0C0), new Color(0xFF8000), new Color(0xFF0080), new Color(0x8000FF), new Color(15368306), new Color(15070684)};

    public void processChart(Object chart, Map params) {
        this.setSubTitle(chart, params);
        this.setTitleFont(chart);
        if (((JFreeChart)chart).getPlot().getClass() == CategoryPlot.class) {
            CategoryPlot plot = (CategoryPlot)((JFreeChart)chart).getPlot();
            this.setMarkers(plot, params);
            CategoryItemRenderer renderer = plot.getRenderer();
            this.setRotatedXaxisLabels(plot, params);
            if (renderer.getClass() == BarRenderer.class) {
                this.setErrorBars(plot);
                this.setBarColors(plot, this.colorRange);
                this.setMargins(plot);
            }
            if (renderer.getClass() == LineAndShapeRenderer.class) {
                this.setLineAndShapesAndErrorBars(plot);
            }
            if (renderer.getClass() == StackedAreaRenderer.class) {
                this.applyStackedAreaRendering(plot);
            }
        } else {
            PiePlot plot = (PiePlot)((JFreeChart)chart).getPlot();
            this.setPieColors(plot, this.colorRange);
            this.setPieLabels(plot);
        }
    }

    private void applyStackedAreaRendering(CategoryPlot plot) {
        plot.setDomainGridlinesVisible(true);
    }

    private void setBarColors(CategoryPlot plot, Color[] aColorRange) {
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        for (int i = 0; i < aColorRange.length; ++i) {
            renderer.setSeriesPaint(i, (Paint)aColorRange[i]);
        }
    }

    private void setErrorBars(CategoryPlot plot) {
        if (plot.getDataset().getClass() == AsymmetricStatisticalCategoryDataset.class) {
            AsymmetricStatisticalBarRenderer barRenderer = new AsymmetricStatisticalBarRenderer();
            plot.setRenderer((CategoryItemRenderer)barRenderer);
        }
    }

    private void setItemLabels(CategoryPlot plot) {
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        renderer.setItemLabelsVisible(true);
        renderer.setItemLabelFont(new Font("SansSerif", 0, 9));
        renderer.setItemLabelPaint(null);
        renderer.setSeriesItemLabelPaint(0, renderer.getSeriesPaint(0));
        renderer.setSeriesItemLabelPaint(1, renderer.getSeriesPaint(1));
    }

    private void setLineAndShapesAndErrorBars(CategoryPlot plot) {
        AsymmetricStatisticalLineAndShapeRenderer renderer = plot.getDataset().getClass() == AsymmetricStatisticalCategoryDataset.class ? new AsymmetricStatisticalLineAndShapeRenderer() : new LineAndShapeRenderer();
        plot.setRenderer((CategoryItemRenderer)renderer);
    }

    private void setMargins(CategoryPlot plot) {
        CategoryAxis axis = plot.getDomainAxis();
        axis.setTickLabelFont(new Font("SansSerif", 0, 9));
        int categoryCount = plot.getCategories().size();
        int seriesCount = plot.getDataset().getRowCount();
        axis.setCategoryMargin(0.23);
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        if (categoryCount == 1) {
            renderer.setItemMargin(0.15);
        } else {
            renderer.setItemMargin(0.03);
        }
        if (categoryCount * seriesCount < 4) {
            double outerMargins = (4.0 - (double)(categoryCount * seriesCount)) / 10.0;
            axis.setLowerMargin(outerMargins);
            axis.setUpperMargin(outerMargins);
        }
    }

    private void setMarkers(CategoryPlot plot, Map params) {
        Marker[] domainMarkers = (Marker[])params.get("domainMarkers");
        if (domainMarkers != null && domainMarkers.length > 0) {
            for (Marker marker : domainMarkers) {
                CategoryMarker cmarker = (CategoryMarker)marker;
                cmarker.setDrawAsLine(true);
                if (cmarker.getLabel() != null) {
                    cmarker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
                    cmarker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
                }
                plot.addDomainMarker(cmarker);
            }
        }
    }

    private void setPieColors(PiePlot plot, Color[] aColorRange) {
        for (int i = 0; i < aColorRange.length; ++i) {
            plot.setSectionPaint(i, (Paint)aColorRange[i]);
        }
    }

    private void setPieLabels(PiePlot plot) {
        plot.setLabelGenerator(null);
    }

    private void setRotatedXaxisLabels(CategoryPlot plot, Map params) {
        Double rotation = (Double)params.get("xlabelRotation");
        int numberOfCategories = plot.getCategories().size();
        if (rotation == null && numberOfCategories > 10) {
            rotation = new Double(0.6);
        }
        if (rotation != null && rotation != 0.0) {
            CategoryAxis axis = plot.getDomainAxis();
            axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)rotation));
        }
    }

    private void setSubTitle(Object chart, Map params) {
        String subtitleString = (String)params.get("subtitle");
        if (subtitleString != null && subtitleString.trim().length() > 0) {
            TextTitle subtitle = new TextTitle(subtitleString);
            subtitle.setFont(subtitle.getFont().deriveFont(11.0f));
            ((JFreeChart)chart).addSubtitle((Title)subtitle);
        }
    }

    private void setTitleFont(Object chart) {
        JFreeChart freeChart = (JFreeChart)chart;
        if (freeChart.getTitle() != null) {
            freeChart.getTitle().setFont(freeChart.getTitle().getFont().deriveFont(14.0f));
        }
    }
}

