/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.statistics.graphs;

import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.utils.jfreeAsymmetric.AsymmetricStatisticalCategoryDataset;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.CategoryToPieDataset;
import org.jfree.data.category.DefaultIntervalCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.util.TableOrder;

class GraphDatasetGenerator {
    static byte calculateScaleFactor(Object dataset) {
        CategoryDataset lDataset = (CategoryDataset)dataset;
        Number maxValue = DatasetUtilities.findMaximumRangeValue((CategoryDataset)lDataset);
        return (byte)GraphDatasetGenerator.getThousands(maxValue.doubleValue());
    }

    protected static String[] createGraphSeries(String[] tableSeries, int seriesCount) {
        String[] seriesNames = new String[seriesCount];
        System.arraycopy(tableSeries, 0, seriesNames, 0, seriesCount);
        return seriesNames;
    }

    static CategoryDataset generateDataset(Number[][] tableData, String[] seriesNames, String[] categories, boolean hasErrorBars) {
        int series = seriesNames.length;
        int cats = categories.length;
        if (hasErrorBars) {
            AsymmetricStatisticalCategoryDataset ds = new AsymmetricStatisticalCategoryDataset();
            for (int s = 0; s < series; ++s) {
                for (int c = 0; c < cats; ++c) {
                    StatisticalNumber data = (StatisticalNumber)tableData[s][c];
                    ds.add(data.isNull() ? null : data, data.getLowerBound(), data.getUpperBound(), (Comparable)((Object)seriesNames[s]), (Comparable)((Object)categories[c]));
                }
            }
            return ds;
        }
        Number[][] endValues = new Number[series][cats];
        Number[][] startValues = new Number[series][cats];
        for (int s = 0; s < series; ++s) {
            for (int c = 0; c < cats; ++c) {
                Number value = tableData[s][c];
                if (value.getClass() == StatisticalNumber.class && ((StatisticalNumber)value).isNull()) continue;
                endValues[s][c] = value;
                startValues[s][c] = new Integer(0);
            }
        }
        DefaultIntervalCategoryDataset ds = new DefaultIntervalCategoryDataset((Comparable[])seriesNames, (Comparable[])categories, startValues, endValues);
        return ds;
    }

    static Dataset generatePieDataset(String[] keys, Number[][] tableData) {
        CategoryDataset catDataset = GraphDatasetGenerator.generateDataset(tableData, keys, new String[]{""}, false);
        CategoryToPieDataset dataset = new CategoryToPieDataset(catDataset, TableOrder.BY_COLUMN, 0);
        return dataset;
    }

    private static int getThousands(double number) {
        return (int)Math.floor(Math.log(number) / Math.log(1000.0));
    }

    static CategoryDataset scaleData(CategoryDataset dataset, byte scaleFactor, boolean hasErrorBars) {
        if (scaleFactor == 0) {
            return dataset;
        }
        double factor = Math.pow(1000.0, scaleFactor);
        if (hasErrorBars) {
            AsymmetricStatisticalCategoryDataset scaledData = new AsymmetricStatisticalCategoryDataset();
            for (int r = 0; r < dataset.getRowCount(); ++r) {
                for (int c = 0; c < dataset.getColumnCount(); ++c) {
                    StatisticalNumber dataPoint = (StatisticalNumber)StatisticalNumber.scale(dataset.getValue(r, c), factor);
                    Comparable columnKey = dataset.getColumnKey(c);
                    Comparable rowKey = dataset.getRowKey(r);
                    scaledData.add(dataPoint, dataPoint == null ? null : dataPoint.getLowerBound(), dataPoint == null ? null : dataPoint.getUpperBound(), rowKey, columnKey);
                }
            }
            return scaledData;
        }
        DefaultIntervalCategoryDataset scaledData = (DefaultIntervalCategoryDataset)dataset;
        for (int r = 0; r < dataset.getRowCount(); ++r) {
            for (int c = 0; c < dataset.getColumnCount(); ++c) {
                Number scaledValue = StatisticalNumber.scale(dataset.getValue(r, c), factor);
                scaledData.setEndValue(r, dataset.getColumnKey(c), scaledValue);
            }
        }
        return scaledData;
    }

    static Number[][] switchXYData(Number[][] input) {
        Number[][] switchedData = new Number[input[0].length][input.length];
        for (int x = 0; x < input.length; ++x) {
            for (int y = 0; y < input[x].length; ++y) {
                switchedData[y][x] = input[x][y];
            }
        }
        return switchedData;
    }

    private GraphDatasetGenerator() {
    }
}

