/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.reports.statistics.graphs;

import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.DatasetProducer;
import de.laures.cewolf.tooltips.CategoryToolTipGenerator;
import de.laures.cewolf.tooltips.PieToolTipGenerator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.reports.statistics.graphs.GraphDatasetGenerator;
import nl.strohalm.cyclos.entities.reports.StatisticalNumber;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.services.stats.general.FilterUsed;
import nl.strohalm.cyclos.utils.conversion.KeyToHelpNameConverter;
import org.jfree.chart.plot.Marker;
import org.jfree.data.Values2D;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;

public class StatisticalDataProducer
implements Serializable,
DatasetProducer,
CategoryToolTipGenerator,
PieToolTipGenerator {
    private static final long serialVersionUID = 3323675832104771077L;
    protected Dataset dataset;
    private final String producerId;
    private final StatisticalResultDTO resultObject;
    private LocalSettings settings;
    private ActionContext context;
    private String[] rowHeaders;
    private final String[] categories;
    private final String[] columnHeaders;
    private String title;
    private String x_axis;
    private String y_axis;
    private Double totalForPie;
    private byte scaleFactor;

    public StatisticalDataProducer(StatisticalResultDTO valueObject, ActionContext context) {
        this.resultObject = valueObject;
        this.producerId = "graphProducer";
        int rows = valueObject.getTableCells().length;
        this.categories = new String[this.resultObject.getCategoriesCount()];
        this.rowHeaders = new String[rows];
        int columns = rows > 0 ? valueObject.getTableCells()[0].length : 0;
        this.columnHeaders = new String[columns];
        this.setResourceStrings(context);
        if (this.getClass() == StatisticalDataProducer.class) {
            this.setDataset();
        }
    }

    private StatisticalDataProducer(StatisticalDataProducer original, int index, int numberOfPoints) {
        boolean byColumn = original.resultObject.getMultiGraph() == StatisticalResultDTO.MultiGraph.BY_COLUMN;
        Number[][] data = new Number[numberOfPoints][1];
        for (int i = 0; i < numberOfPoints; ++i) {
            data[i][0] = byColumn ? (Number)original.getTableCells()[i][index] : (Number)original.getTableCells()[index][i];
        }
        this.resultObject = new StatisticalResultDTO(data);
        this.resultObject.setGraphType(original.resultObject.getGraphType());
        String units = original.getColumnSubHeaders()[index];
        if (units.indexOf("(") == 0 && units.lastIndexOf(")") == units.length() - 1) {
            units = units.substring(1, units.length() - 1);
        }
        this.resultObject.setYAxisUnits(units);
        this.producerId = "graphProducer";
        this.categories = new String[numberOfPoints];
        System.arraycopy(byColumn ? original.categories : original.getColumnHeaders(), 0, this.categories, 0, numberOfPoints);
        this.columnHeaders = new String[1];
        this.columnHeaders[0] = byColumn ? original.columnHeaders[index] : original.categories[index];
        int numberOfGraphs = byColumn ? original.columnHeaders.length : original.categories.length;
        this.x_axis = index == numberOfGraphs - 1 ? original.getX_axis() : "";
        this.y_axis = byColumn ? original.columnHeaders[index] : original.categories[index];
        this.settings = original.settings;
        this.setDataset();
    }

    public String generateToolTip(CategoryDataset lDataset, int series, int lCategories) {
        try {
            Number number = lDataset.getValue(series, lCategories);
            try {
                byte precision;
                byte by = precision = number instanceof StatisticalNumber ? ((StatisticalNumber)number).getPrecision() : (byte)0;
                if (this.settings != null) {
                    BigDecimal value = new BigDecimal(1000).pow(this.scaleFactor).multiply(new BigDecimal(number.floatValue()));
                    String result = this.settings.getNumberConverterForPrecision(precision).toString(value);
                    return result;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return String.valueOf(number.doubleValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    public String generateToolTip(PieDataset dataset, Comparable key, int pieIndex) {
        try {
            Number number = dataset.getValue(key);
            try {
                byte precision;
                byte by = precision = number instanceof StatisticalNumber ? ((StatisticalNumber)number).getPrecision() : (byte)0;
                if (this.settings != null) {
                    BigDecimal value = new BigDecimal(1000).pow(this.scaleFactor).multiply(new BigDecimal(number.floatValue()));
                    int percentage = (int)Math.round(value.divide(new BigDecimal(this.getTotalForPie())).doubleValue() * 100.0);
                    String result = this.settings.getNumberConverterForPrecision(precision).toString(value) + " (=" + percentage + "%)";
                    return result;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            String result = String.valueOf(number.doubleValue());
            int percentage = (int)Math.round(100.0 * (number.doubleValue() / this.getTotalForPie()));
            return result + " (=" + percentage + "%)";
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getBaseKey() {
        return this.resultObject.getBaseKey();
    }

    public String[] getColumnHeaders() {
        return this.columnHeaders;
    }

    public String[] getColumnSubHeaders() {
        return this.resultObject.getColumnSubHeaders();
    }

    public Marker[] getDomainMarkers() {
        return this.resultObject.getDomainMarkers();
    }

    public int getFilterCount() {
        return this.resultObject.getFiltersUsed().size();
    }

    public List<FilterUsed> getFiltersUsed() {
        int size;
        List<FilterUsed> filterList = this.resultObject.getFiltersUsed();
        int maxSize = 0;
        for (FilterUsed filterUsed : filterList) {
            size = filterUsed.getValues().size();
            if (size <= maxSize) continue;
            maxSize = size;
        }
        for (FilterUsed filterUsed : filterList) {
            if (filterUsed.getFilterUse() == FilterUsed.FilterUse.NO_SELECT || filterUsed.getFilterUse() == FilterUsed.FilterUse.NOT_USED) {
                for (String key : filterUsed.getValues()) {
                    filterUsed.changeKeyToValue(key, this.context.message(key, new Object[0]));
                }
            }
            size = filterUsed.getValues().size();
            filterUsed.addBlankRows(maxSize - size);
        }
        return filterList;
    }

    public String getGraphTypeValue() {
        return this.resultObject.getGraphType().getValue();
    }

    public int getHeight() {
        if (this.getShowLegend().equals("false")) {
            return 300;
        }
        return (int)Math.round(300.0 + (double)this.getRowHeaders().length * 150.0 / 20.0);
    }

    public String getHelpAnchor() {
        KeyToHelpNameConverter converter = new KeyToHelpNameConverter();
        return converter.toString(this.getBaseKey());
    }

    public String getHelpFile() {
        return this.resultObject.getHelpFile();
    }

    public StatisticalDataProducer[] getMultiGraphProducers() {
        if (!this.isMultiGraph()) {
            return null;
        }
        int numberOfGraphs = this.resultObject.getMultiGraph() == StatisticalResultDTO.MultiGraph.BY_COLUMN ? this.getColumnHeaders().length : this.getRowHeaders().length;
        StatisticalDataProducer[] producerArray = new StatisticalDataProducer[numberOfGraphs];
        for (int i = 0; i < numberOfGraphs; ++i) {
            StatisticalDataProducer item;
            producerArray[i] = item = new StatisticalDataProducer(this, i, this.resultObject.getCategoriesCount());
        }
        return producerArray;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public String[] getRowHeaders() {
        return this.rowHeaders;
    }

    public String getShowLegend() {
        if (this.resultObject.getGraphType() == StatisticalResultDTO.GraphType.PIE) {
            return "true";
        }
        Values2D values2D = (Values2D)this.dataset;
        if (values2D.getRowCount() == 1) {
            return "false";
        }
        return "true";
    }

    public String getSubTitle() {
        String subTitle = this.resultObject.getSubTitle();
        if (subTitle == null) {
            return "";
        }
        return subTitle;
    }

    public Number[][] getTableCells() {
        return this.resultObject.getTableCells();
    }

    public int getTableColumnCount() {
        return this.getColumnHeaders().length + 1;
    }

    public String getTitle() {
        if (this.title == null && this.context != null) {
            return this.context.message(this.getBaseKey(), new Object[0]);
        }
        return this.title;
    }

    public String getX_axis() {
        if (this.x_axis.startsWith("???") & this.x_axis.endsWith("???")) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.x_axis);
        if (this.resultObject.getScaleFactorX() == null) {
            if (this.resultObject.getXAxisUnits().length() > 0) {
                sb.append("  ").append("(").append(this.resultObject.getXAxisUnits()).append(")");
            }
            return sb.toString();
        }
        sb.append("   ").append(this.resultObject.getScaleFactorX());
        if (this.resultObject.getXAxisUnits().length() > 0) {
            sb.insert(sb.length() - 1, " ").insert(sb.length() - 1, this.resultObject.getXAxisUnits());
        }
        return sb.toString();
    }

    public String getY_axis() {
        if (this.scaleFactor == 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.y_axis);
            if (this.resultObject.getYAxisUnits().length() > 0) {
                sb.append("  ").append("(").append(this.resultObject.getYAxisUnits()).append(")");
            }
            return sb.toString();
        }
        String factorSign = this.scaleFactor < 0 ? this.resultObject.getYAxisUnits() + "/" : "x";
        int factor = (int)Math.pow(1000.0, Math.abs(this.scaleFactor));
        StringBuilder sb = new StringBuilder();
        if (this.settings != null) {
            sb.append(this.settings.getNumberConverterForPrecision(0).toString(new BigDecimal(factor)));
        } else {
            sb.append(String.valueOf(factor));
        }
        sb.insert(0, factorSign).insert(0, "   (");
        if (this.scaleFactor > 0 && this.resultObject.getYAxisUnits().length() > 0) {
            sb.append(" ").append(this.resultObject.getYAxisUnits());
        }
        sb.append(")");
        sb.insert(0, this.y_axis);
        return sb.toString();
    }

    public boolean hasExpired(Map arg0, Date arg1) {
        return true;
    }

    public boolean isMultiGraph() {
        return this.resultObject.getMultiGraph() != StatisticalResultDTO.MultiGraph.NONE;
    }

    public boolean isShowAppliedFilters() {
        return this.resultObject.getFiltersUsed().size() > 0;
    }

    public boolean isShowGraph() {
        return this.resultObject.getGraphType() != StatisticalResultDTO.GraphType.NONE;
    }

    public boolean isShowTable() {
        return this.resultObject.isShowTable();
    }

    public Object produceDataset(Map params) throws DatasetProduceException {
        return this.dataset;
    }

    public void setSettings(LocalSettings settings) {
        this.settings = settings;
    }

    protected boolean hasErrorBars() {
        return this.resultObject.hasErrorBars();
    }

    protected void setDataset() {
        if (this.resultObject.getGraphType() == StatisticalResultDTO.GraphType.PIE) {
            this.dataset = GraphDatasetGenerator.generatePieDataset(this.getRowHeaders(), this.getTableCells());
            return;
        }
        if (this.isShowGraph() && !this.isMultiGraph()) {
            Number[][] dataArray;
            String[] seriesNames;
            boolean errorBars = this.resultObject.hasErrorBars();
            if (this.resultObject.isDontSwitchXY()) {
                seriesNames = GraphDatasetGenerator.createGraphSeries(this.getRowHeaders(), this.resultObject.getSeriesCount());
                dataArray = this.getTableCells();
            } else {
                seriesNames = GraphDatasetGenerator.createGraphSeries(this.getColumnHeaders(), this.resultObject.getSeriesCount());
                dataArray = GraphDatasetGenerator.switchXYData(this.getTableCells());
            }
            CategoryDataset dataset = GraphDatasetGenerator.generateDataset(dataArray, seriesNames, this.categories, errorBars);
            this.scaleFactor = this.calculateScaleFactor(dataset);
            this.dataset = GraphDatasetGenerator.scaleData(dataset, this.scaleFactor, errorBars);
        }
    }

    private byte calculateScaleFactor(Object dataset) {
        if (this.isShowGraph() && !this.isMultiGraph()) {
            return GraphDatasetGenerator.calculateScaleFactor(dataset);
        }
        return 0;
    }

    private double getTotalForPie() {
        if (this.totalForPie == null) {
            double result = 0.0;
            for (int i = 0; i < this.resultObject.getTableCells().length; ++i) {
                result += this.resultObject.getTableCells()[i][0].doubleValue();
            }
            this.totalForPie = result;
        }
        return this.totalForPie;
    }

    private void setResourceStrings(ActionContext context) {
        int i;
        this.context = context;
        this.title = context.message(this.getBaseKey(), new Object[0]);
        this.x_axis = context.message(this.getBaseKey() + ".xAxis", new Object[0]);
        this.y_axis = context.message(this.getBaseKey() + ".yAxis", new Object[0]);
        for (i = 0; i < this.rowHeaders.length; ++i) {
            if (this.resultObject.getRowHeader(i) != null) {
                this.rowHeaders[i] = this.resultObject.getRowHeader(i);
                if (this.resultObject.isDontSwitchXY() || i >= this.resultObject.getCategoriesCount()) continue;
                this.categories[i] = this.rowHeaders[i];
                continue;
            }
            this.rowHeaders[i] = context.message(this.resultObject.getRowKey(i), this.resultObject.getRowKeyArgs(i));
            if (this.resultObject.isDontSwitchXY() || i >= this.resultObject.getCategoriesCount()) continue;
            this.categories[i] = context.message(this.resultObject.getRowKey(i) + ".short", new Object[0]);
            if (!(this.categories[i].startsWith("???") & this.categories[i].endsWith("???"))) continue;
            this.categories[i] = "";
        }
        for (i = 0; i < this.columnHeaders.length; ++i) {
            if (this.resultObject.getColumnHeader(i) != null) {
                this.columnHeaders[i] = this.resultObject.getColumnHeader(i);
                if (!this.resultObject.isDontSwitchXY() || i >= this.resultObject.getCategoriesCount()) continue;
                this.categories[i] = this.columnHeaders[i];
                continue;
            }
            this.columnHeaders[i] = context.message(this.resultObject.getColumnKey(i), new Object[0]);
            if (!this.resultObject.isDontSwitchXY() || i >= this.resultObject.getCategoriesCount()) continue;
            this.categories[i] = context.message(this.resultObject.getColumnKey(i) + ".short", new Object[0]);
            if (!(this.categories[i].startsWith("???") & this.categories[i].endsWith("???"))) continue;
            this.categories[i] = "";
        }
    }
}

