/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.services;

import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.services.EditServiceClientForm;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.services.ServiceOperation;
import nl.strohalm.cyclos.services.services.ServiceClientService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.struts.action.ActionForward;

public class EditServiceClientAction
extends BaseFormAction {
    private ServiceClientService serviceClientService;
    private DataBinder<ServiceClient> dataBinder;

    @Inject
    public void setServiceClientService(ServiceClientService serviceClientService) {
        this.serviceClientService = serviceClientService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditServiceClientForm form = (EditServiceClientForm)((Object)context.getForm());
        ServiceClient client = this.getDataBinder().readFromString(form.getServiceClient());
        boolean isInsert = client.isTransient();
        this.serviceClientService.save(client);
        context.sendMessage(isInsert ? "serviceClient.inserted" : "serviceClient.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "clientId", client.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        ServiceClient client;
        HttpServletRequest request = context.getRequest();
        EditServiceClientForm form = (EditServiceClientForm)((Object)context.getForm());
        long id = form.getClientId();
        if (id <= 0L) {
            client = new ServiceClient();
        } else {
            client = this.serviceClientService.load(id, ServiceClient.Relationships.MEMBER, ServiceClient.Relationships.PERMISSIONS);
            List<TransferType> doPaymentTypes = this.serviceClientService.listPossibleDoPaymentTypes(client);
            List<TransferType> receivePaymentTypes = this.serviceClientService.listPossibleReceivePaymentTypes(client);
            request.setAttribute("doPaymentTypes", doPaymentTypes);
            request.setAttribute("receivePaymentTypes", receivePaymentTypes);
            request.setAttribute("chargebackPaymentTypes", client.getMember() == null ? doPaymentTypes : receivePaymentTypes);
        }
        GroupQuery groupQuery = new GroupQuery();
        groupQuery.setManagedBy((AdminGroup)context.getGroup());
        groupQuery.setNatures(Group.Nature.BROKER, Group.Nature.MEMBER);
        List<? extends Group> memberGroups = this.groupService.search(groupQuery);
        this.getDataBinder().writeAsString(form.getServiceClient(), client);
        request.setAttribute("serviceClient", (Object)client);
        request.setAttribute("channels", this.serviceClientService.listPossibleChannels());
        request.setAttribute("memberGroups", memberGroups);
        RequestHelper.storeEnum(request, ServiceOperation.class, "operations");
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditServiceClientForm form = (EditServiceClientForm)((Object)context.getForm());
        ServiceClient client = this.getDataBinder().readFromString(form.getServiceClient());
        this.serviceClientService.validate(client);
    }

    private DataBinder<ServiceClient> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<ServiceClient> binder = BeanBinder.instance(ServiceClient.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("hostname", PropertyBinder.instance(String.class, "hostname"));
            binder.registerBinder("username", PropertyBinder.instance(String.class, "username"));
            binder.registerBinder("password", PropertyBinder.instance(String.class, "password"));
            binder.registerBinder("credentialsRequired", PropertyBinder.instance(Boolean.TYPE, "credentialsRequired"));
            binder.registerBinder("ignoreRegistrationValidations", PropertyBinder.instance(Boolean.TYPE, "ignoreRegistrationValidations"));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            binder.registerBinder("channel", PropertyBinder.instance(Channel.class, "channel"));
            binder.registerBinder("permissions", SimpleCollectionBinder.instance(ServiceOperation.class, Set.class, "permissions"));
            binder.registerBinder("doPaymentTypes", SimpleCollectionBinder.instance(TransferType.class, Set.class, "doPaymentTypes"));
            binder.registerBinder("receivePaymentTypes", SimpleCollectionBinder.instance(TransferType.class, Set.class, "receivePaymentTypes"));
            binder.registerBinder("chargebackPaymentTypes", SimpleCollectionBinder.instance(TransferType.class, Set.class, "chargebackPaymentTypes"));
            binder.registerBinder("manageGroups", SimpleCollectionBinder.instance(MemberGroup.class, Set.class, "manageGroups"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

