/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.services;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.services.SearchServiceClientsForm;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.services.ServiceClientQuery;
import nl.strohalm.cyclos.entities.services.ServiceOperation;
import nl.strohalm.cyclos.services.services.ServiceClientService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchServiceClientsAction
extends BaseQueryAction {
    private ServiceClientService serviceClientService;
    private DataBinder<ServiceClientQuery> dataBinder;

    @Inject
    public void setServiceClientService(ServiceClientService serviceClientService) {
        this.serviceClientService = serviceClientService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        ServiceClientQuery query = (ServiceClientQuery)queryParameters;
        List<ServiceClient> clients = this.serviceClientService.search(query);
        context.getRequest().setAttribute("serviceClients", clients);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        SearchServiceClientsForm form = (SearchServiceClientsForm)((Object)context.getForm());
        ServiceClientQuery query = this.getDataBinder().readFromString(form.getQuery());
        RequestHelper.storeEnum(request, ServiceOperation.class, "operations");
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private DataBinder<ServiceClientQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<ServiceClientQuery> binder = BeanBinder.instance(ServiceClientQuery.class);
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

