/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.settings;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.settings.EditAccessSettingsForm;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;

public class EditAccessSettingsAction
extends BaseFormAction {
    private DataBinder<AccessSettings> dataBinder;

    public DataBinder<AccessSettings> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<AccessSettings> binder = BeanBinder.instance(AccessSettings.class);
            binder.registerBinder("virtualKeyboard", PropertyBinder.instance(Boolean.TYPE, "virtualKeyboard"));
            binder.registerBinder("virtualKeyboardTransactionPassword", PropertyBinder.instance(Boolean.TYPE, "virtualKeyboardTransactionPassword"));
            binder.registerBinder("numericPassword", PropertyBinder.instance(Boolean.TYPE, "numericPassword"));
            binder.registerBinder("allowMultipleLogins", PropertyBinder.instance(Boolean.TYPE, "allowMultipleLogins"));
            binder.registerBinder("allowOperatorLogin", PropertyBinder.instance(Boolean.TYPE, "allowOperatorLogin"));
            binder.registerBinder("adminTimeout", DataBinderHelper.timePeriodBinder("adminTimeout"));
            binder.registerBinder("administrationWhitelist", PropertyBinder.instance(String.class, "administrationWhitelist"));
            binder.registerBinder("memberTimeout", DataBinderHelper.timePeriodBinder("memberTimeout"));
            binder.registerBinder("poswebTimeout", DataBinderHelper.timePeriodBinder("poswebTimeout"));
            binder.registerBinder("usernameLength", DataBinderHelper.rangeConstraintBinder("usernameLength"));
            binder.registerBinder("usernameGeneration", PropertyBinder.instance(AccessSettings.UsernameGeneration.class, "usernameGeneration"));
            binder.registerBinder("generatedUsernameLength", PropertyBinder.instance(Integer.TYPE, "generatedUsernameLength"));
            binder.registerBinder("transactionPasswordChars", PropertyBinder.instance(String.class, "transactionPasswordChars"));
            binder.registerBinder("usernameRegex", PropertyBinder.instance(String.class, "usernameRegex"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public SettingsService getSettingsService() {
        return this.settingsService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        EditAccessSettingsForm form = (EditAccessSettingsForm)((Object)context.getForm());
        AccessSettings settings = this.getDataBinder().readFromString(form.getSetting());
        settings = this.settingsService.save(settings);
        context.sendMessage("settings.access.modified", new Object[0]);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditAccessSettingsForm form = (EditAccessSettingsForm)((Object)context.getForm());
        this.getDataBinder().writeAsString(form.getSetting(), this.settingsService.getAccessSettings());
        RequestHelper.storeEnum(request, AccessSettings.UsernameGeneration.class, "usernameGenerations");
        request.setAttribute("timePeriodFields", Arrays.asList(TimePeriod.Field.SECONDS, TimePeriod.Field.MINUTES, TimePeriod.Field.HOURS, TimePeriod.Field.DAYS));
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditAccessSettingsForm form = (EditAccessSettingsForm)((Object)context.getForm());
        AccessSettings settings = this.getDataBinder().readFromString(form.getSetting());
        this.settingsService.validate(settings);
    }
}

