/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.settings;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.settings.EditAlertSettingsForm;
import nl.strohalm.cyclos.entities.settings.AlertSettings;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;

public class EditAlertSettingsAction
extends BaseFormAction {
    private DataBinder<AlertSettings> dataBinder;

    public DataBinder<AlertSettings> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<AlertSettings> binder = BeanBinder.instance(AlertSettings.class);
            binder.registerBinder("givenVeryBadRefs", PropertyBinder.instance(Integer.TYPE, "givenVeryBadRefs"));
            binder.registerBinder("receivedVeryBadRefs", PropertyBinder.instance(Integer.TYPE, "receivedVeryBadRefs"));
            binder.registerBinder("idleInvoiceExpiration", DataBinderHelper.timePeriodBinder("idleInvoiceExpiration"));
            binder.registerBinder("amountDeniedInvoices", PropertyBinder.instance(Integer.TYPE, "amountDeniedInvoices"));
            binder.registerBinder("amountIncorrectLogin", PropertyBinder.instance(Integer.TYPE, "amountIncorrectLogin"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public SettingsService getSettingsService() {
        return this.settingsService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        EditAlertSettingsForm form = (EditAlertSettingsForm)((Object)context.getForm());
        AlertSettings settings = this.getDataBinder().readFromString(form.getSetting());
        settings = this.settingsService.save(settings);
        context.sendMessage("settings.alert.modified", new Object[0]);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditAlertSettingsForm form = (EditAlertSettingsForm)((Object)context.getForm());
        this.getDataBinder().writeAsString(form.getSetting(), this.settingsService.getAlertSettings());
        request.setAttribute("timePeriodFields", Arrays.asList(TimePeriod.Field.DAYS, TimePeriod.Field.WEEKS, TimePeriod.Field.MONTHS));
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditAlertSettingsForm form = (EditAlertSettingsForm)((Object)context.getForm());
        AlertSettings settings = this.getDataBinder().readFromString(form.getSetting());
        this.settingsService.validate(settings);
    }
}

