/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.settings.EditLocalSettingsForm;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.customization.MessageImportType;
import nl.strohalm.cyclos.services.customization.TranslationMessageService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.FileUnits;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.TextFormat;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.MapBean;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.TimeZoneConverter;
import org.apache.commons.lang.StringUtils;

public class EditLocalSettingsAction
extends BaseFormAction {
    private ChannelService channelService;
    private TranslationMessageService translationMessageService;
    private DataBinder<LocalSettings> dataBinder;

    public DataBinder<LocalSettings> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<LocalSettings.TransactionNumber> transactionNumberBinder = BeanBinder.instance(LocalSettings.TransactionNumber.class, "transactionNumber");
            transactionNumberBinder.registerBinder("prefix", PropertyBinder.instance(String.class, "prefix"));
            transactionNumberBinder.registerBinder("padLength", PropertyBinder.instance(Integer.TYPE, "padLength"));
            transactionNumberBinder.registerBinder("suffix", PropertyBinder.instance(String.class, "suffix"));
            transactionNumberBinder.registerBinder("enabled", PropertyBinder.instance(Boolean.TYPE, "enabled"));
            BeanBinder<LocalSettings> binder = BeanBinder.instance(LocalSettings.class);
            binder.registerBinder("applicationName", PropertyBinder.instance(String.class, "applicationName"));
            binder.registerBinder("applicationUsername", PropertyBinder.instance(String.class, "applicationUsername"));
            binder.registerBinder("rootUrl", PropertyBinder.instance(String.class, "rootUrl"));
            binder.registerBinder("language", PropertyBinder.instance(LocalSettings.Language.class, "language"));
            binder.registerBinder("numberLocale", PropertyBinder.instance(LocalSettings.NumberLocale.class, "numberLocale"));
            binder.registerBinder("precision", PropertyBinder.instance(LocalSettings.Precision.class, "precision"));
            binder.registerBinder("highPrecision", PropertyBinder.instance(LocalSettings.Precision.class, "highPrecision"));
            binder.registerBinder("decimalInputMethod", PropertyBinder.instance(LocalSettings.DecimalInputMethod.class, "decimalInputMethod"));
            binder.registerBinder("datePattern", PropertyBinder.instance(LocalSettings.DatePattern.class, "datePattern"));
            binder.registerBinder("timePattern", PropertyBinder.instance(LocalSettings.TimePattern.class, "timePattern"));
            binder.registerBinder("timeZone", PropertyBinder.instance(TimeZone.class, "timeZone", TimeZoneConverter.instance()));
            binder.registerBinder("containerUrl", PropertyBinder.instance(String.class, "containerUrl"));
            binder.registerBinder("maxIteratorResults", PropertyBinder.instance(Integer.TYPE, "maxIteratorResults"));
            binder.registerBinder("maxPageResults", PropertyBinder.instance(Integer.TYPE, "maxPageResults"));
            binder.registerBinder("maxAjaxResults", PropertyBinder.instance(Integer.TYPE, "maxAjaxResults"));
            binder.registerBinder("maxUploadSize", PropertyBinder.instance(Integer.TYPE, "maxUploadSize"));
            binder.registerBinder("maxUploadUnits", PropertyBinder.instance(FileUnits.class, "maxUploadUnits"));
            binder.registerBinder("maxImageWidth", PropertyBinder.instance(Integer.TYPE, "maxImageWidth"));
            binder.registerBinder("maxImageHeight", PropertyBinder.instance(Integer.TYPE, "maxImageHeight"));
            binder.registerBinder("maxThumbnailWidth", PropertyBinder.instance(Integer.TYPE, "maxThumbnailWidth"));
            binder.registerBinder("maxThumbnailHeight", PropertyBinder.instance(Integer.TYPE, "maxThumbnailHeight"));
            binder.registerBinder("csvUseHeader", PropertyBinder.instance(Boolean.TYPE, "csvUseHeader"));
            binder.registerBinder("csvRecordSeparator", PropertyBinder.instance(LocalSettings.CsvRecordSeparator.class, "csvRecordSeparator"));
            binder.registerBinder("csvValueSeparator", PropertyBinder.instance(LocalSettings.CsvValueSeparator.class, "csvValueSeparator"));
            binder.registerBinder("csvStringQuote", PropertyBinder.instance(LocalSettings.CsvStringQuote.class, "csvStringQuote"));
            binder.registerBinder("cyclosId", PropertyBinder.instance(String.class, "cyclosId"));
            binder.registerBinder("smsEnabled", PropertyBinder.instance(Boolean.TYPE, "smsEnabled"));
            binder.registerBinder("sendSmsWebServiceUrl", PropertyBinder.instance(String.class, "sendSmsWebServiceUrl"));
            binder.registerBinder("smsCustomFieldId", PropertyBinder.instance(Long.TYPE, "smsCustomFieldId"));
            binder.registerBinder("smsChannelName", PropertyBinder.instance(String.class, "smsChannelName"));
            binder.registerBinder("emailRequired", PropertyBinder.instance(Boolean.TYPE, "emailRequired"));
            binder.registerBinder("emailUnique", PropertyBinder.instance(Boolean.TYPE, "emailUnique"));
            binder.registerBinder("transactionNumber", transactionNumberBinder);
            binder.registerBinder("brokeringExpirationPeriod", DataBinderHelper.timePeriodBinder("brokeringExpirationPeriod"));
            binder.registerBinder("deleteMessagesOnTrashAfter", DataBinderHelper.timePeriodBinder("deleteMessagesOnTrashAfter"));
            binder.registerBinder("deletePendingRegistrationsAfter", DataBinderHelper.timePeriodBinder("deletePendingRegistrationsAfter"));
            binder.registerBinder("memberSortOrder", PropertyBinder.instance(LocalSettings.SortOrder.class, "memberSortOrder"));
            binder.registerBinder("memberResultDisplay", PropertyBinder.instance(LocalSettings.MemberResultDisplay.class, "memberResultDisplay"));
            binder.registerBinder("adDescriptionFormat", PropertyBinder.instance(TextFormat.class, "adDescriptionFormat"));
            binder.registerBinder("messageFormat", PropertyBinder.instance(TextFormat.class, "messageFormat"));
            binder.registerBinder("schedulingHour", PropertyBinder.instance(Integer.TYPE, "schedulingHour"));
            binder.registerBinder("schedulingMinute", PropertyBinder.instance(Integer.TYPE, "schedulingMinute"));
            binder.registerBinder("transferListenerClass", PropertyBinder.instance(String.class, "transferListenerClass"));
            binder.registerBinder("maxChargebackTime", DataBinderHelper.timePeriodBinder("maxChargebackTime"));
            binder.registerBinder("chargebackDescription", PropertyBinder.instance(String.class, "chargebackDescription"));
            binder.registerBinder("showCountersInAdCategories", PropertyBinder.instance(Boolean.TYPE, "showCountersInAdCategories"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public TranslationMessageService getMessageService() {
        return this.translationMessageService;
    }

    public SettingsService getSettingsService() {
        return this.settingsService;
    }

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Inject
    public void setTranslationMessageService(TranslationMessageService translationMessageService) {
        this.translationMessageService = translationMessageService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        LocalSettings oldSettings = this.settingsService.getLocalSettings();
        LocalSettings settings = this.resolveLocalSettings(context);
        settings = this.settingsService.save(settings);
        if (oldSettings.getLanguage() != settings.getLanguage()) {
            Properties properties = this.translationMessageService.readFile(settings.getLocale());
            this.translationMessageService.importFromProperties(properties, MessageImportType.REPLACE);
            this.settingsService.reloadTranslation();
        }
        context.sendMessage("settings.local.modified", new Object[0]);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditLocalSettingsForm form = (EditLocalSettingsForm)((Object)context.getForm());
        LocalSettings settings = this.settingsService.getLocalSettings();
        form.setSetting("enableSms", StringUtils.isNotEmpty((String)settings.getSendSmsWebServiceUrl()) || StringUtils.isNotEmpty((String)settings.getSmsChannelName()));
        LocalSettings.TransactionNumber transactionNumber = settings.getTransactionNumber();
        form.setSetting("enableTransactionNumber", transactionNumber != null && transactionNumber.getPadLength() > 0);
        this.getDataBinder().writeAsString(form.getSetting(), settings);
        RequestHelper.storeEnum(request, LocalSettings.Language.class, "languages");
        RequestHelper.storeEnum(request, FileUnits.class, "uploadUnits");
        RequestHelper.storeEnum(request, LocalSettings.NumberLocale.class, "numberLocales");
        RequestHelper.storeEnum(request, LocalSettings.Precision.class, "precisions");
        RequestHelper.storeEnum(request, LocalSettings.DecimalInputMethod.class, "decimalInputMethods");
        LinkedHashMap<LocalSettings.DatePattern, String> datePatterns = new LinkedHashMap<LocalSettings.DatePattern, String>();
        for (LocalSettings.DatePattern datePattern : LocalSettings.DatePattern.values()) {
            datePatterns.put(datePattern, this.messageHelper.getDatePatternDescription(datePattern).toUpperCase());
        }
        request.setAttribute("datePatterns", datePatterns);
        RequestHelper.storeEnum(request, LocalSettings.TimePattern.class, "timePatterns");
        RequestHelper.storeEnum(request, LocalSettings.CsvRecordSeparator.class, "csvRecordSeparators");
        RequestHelper.storeEnum(request, LocalSettings.CsvValueSeparator.class, "csvValueSeparators");
        RequestHelper.storeEnum(request, LocalSettings.CsvStringQuote.class, "csvStringQuotes");
        RequestHelper.storeEnum(request, LocalSettings.MemberResultDisplay.class, "memberResultDisplays");
        RequestHelper.storeEnum(request, LocalSettings.SortOrder.class, "memberSortOrders");
        RequestHelper.storeEnum(request, TextFormat.class, "textFormats");
        request.setAttribute("brokeringExpirationUnits", Arrays.asList(TimePeriod.Field.DAYS, TimePeriod.Field.MONTHS, TimePeriod.Field.YEARS));
        request.setAttribute("deleteMessagesExpirationUnits", Arrays.asList(TimePeriod.Field.DAYS, TimePeriod.Field.MONTHS, TimePeriod.Field.YEARS));
        request.setAttribute("maxChargebackTimeUnits", Arrays.asList(TimePeriod.Field.DAYS, TimePeriod.Field.WEEKS, TimePeriod.Field.MONTHS));
        request.setAttribute("indexRebuildingTimeUnits", Arrays.asList(TimePeriod.Field.DAYS, TimePeriod.Field.WEEKS, TimePeriod.Field.MONTHS));
        request.setAttribute("smsChannels", this.channelService.listNonBuiltin());
        request.setAttribute("smsCustomFields", this.channelService.possibleCustomFieldsAsPrincipal());
        ArrayList<String> timeZones = new ArrayList<String>();
        for (String id : TimeZone.getAvailableIDs()) {
            if (!id.contains("/") || id.contains("Etc")) continue;
            timeZones.add(id);
        }
        Collections.sort(timeZones);
        timeZones.add(0, "GMT");
        request.setAttribute("timeZones", timeZones);
    }

    @Override
    protected void validateForm(ActionContext context) {
        LocalSettings settings = this.resolveLocalSettings(context);
        this.settingsService.validate(settings);
    }

    private LocalSettings resolveLocalSettings(ActionContext context) {
        EditLocalSettingsForm form = (EditLocalSettingsForm)((Object)context.getForm());
        LocalSettings settings = this.getDataBinder().readFromString(form.getSetting());
        MapBean tn = (MapBean)form.getSetting("transactionNumber");
        if (!Boolean.parseBoolean((String)tn.get("enabled"))) {
            settings.setTransactionNumber(null);
        }
        return settings;
    }
}

