/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.settings;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.settings.EditLogSettingsForm;
import nl.strohalm.cyclos.entities.settings.LogSettings;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.FileUnits;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;

public class EditLogSettingsAction
extends BaseFormAction {
    private DataBinder<LogSettings> dataBinder;

    public DataBinder<LogSettings> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<LogSettings> binder = BeanBinder.instance(LogSettings.class);
            binder.registerBinder("traceLevel", PropertyBinder.instance(LogSettings.TraceLevel.class, "traceLevel"));
            binder.registerBinder("traceFile", PropertyBinder.instance(String.class, "traceFile"));
            binder.registerBinder("traceWritesOnly", PropertyBinder.instance(Boolean.TYPE, "traceWritesOnly"));
            binder.registerBinder("webServiceLevel", PropertyBinder.instance(LogSettings.WebServiceLevel.class, "webServiceLevel"));
            binder.registerBinder("webServiceFile", PropertyBinder.instance(String.class, "webServiceFile"));
            binder.registerBinder("restLevel", PropertyBinder.instance(LogSettings.WebServiceLevel.class, "restLevel"));
            binder.registerBinder("restFile", PropertyBinder.instance(String.class, "restFile"));
            binder.registerBinder("transactionLevel", PropertyBinder.instance(LogSettings.TransactionLevel.class, "transactionLevel"));
            binder.registerBinder("transactionFile", PropertyBinder.instance(String.class, "transactionFile"));
            binder.registerBinder("accountFeeLevel", PropertyBinder.instance(LogSettings.AccountFeeLevel.class, "accountFeeLevel"));
            binder.registerBinder("accountFeeFile", PropertyBinder.instance(String.class, "accountFeeFile"));
            binder.registerBinder("scheduledTaskLevel", PropertyBinder.instance(LogSettings.ScheduledTaskLevel.class, "scheduledTaskLevel"));
            binder.registerBinder("scheduledTaskFile", PropertyBinder.instance(String.class, "scheduledTaskFile"));
            binder.registerBinder("maxFilesPerLog", PropertyBinder.instance(Integer.TYPE, "maxFilesPerLog"));
            binder.registerBinder("maxLengthPerFile", PropertyBinder.instance(Integer.TYPE, "maxLengthPerFile"));
            binder.registerBinder("maxLengthPerFileUnits", PropertyBinder.instance(FileUnits.class, "maxLengthPerFileUnits"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public SettingsService getSettingsService() {
        return this.settingsService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        EditLogSettingsForm form = (EditLogSettingsForm)((Object)context.getForm());
        LogSettings settings = this.getDataBinder().readFromString(form.getSetting());
        settings = this.settingsService.save(settings);
        context.sendMessage("settings.log.modified", new Object[0]);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        EditLogSettingsForm form = (EditLogSettingsForm)((Object)context.getForm());
        LogSettings settings = this.settingsService.getLogSettings();
        this.getDataBinder().writeAsString(form.getSetting(), settings);
        RequestHelper.storeEnum(request, LogSettings.TraceLevel.class, "traceLevels");
        RequestHelper.storeEnum(request, LogSettings.WebServiceLevel.class, "webServiceLevels");
        RequestHelper.storeEnum(request, LogSettings.TransactionLevel.class, "transactionLevels");
        RequestHelper.storeEnum(request, LogSettings.AccountFeeLevel.class, "accountFeeLevels");
        RequestHelper.storeEnum(request, LogSettings.ScheduledTaskLevel.class, "scheduledTaskLevels");
        RequestHelper.storeEnum(request, FileUnits.class, "fileUnits");
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditLogSettingsForm form = (EditLogSettingsForm)((Object)context.getForm());
        LogSettings settings = this.getDataBinder().readFromString(form.getSetting());
        this.settingsService.validate(settings);
    }
}

