/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.settings;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.settings.EditMessageSettingForm;
import nl.strohalm.cyclos.entities.settings.MessageSettings;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.TextFormat;
import nl.strohalm.cyclos.utils.binding.PropertyException;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.StringTrimmerConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class EditMessageSettingAction
extends BaseFormAction {
    public static final int MAX_SUBJECT_SIZE = 400;
    public static final int MAX_BODY_SIZE = 4000;
    public static final int MAX_SMS_SIZE = 256;

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditMessageSettingForm form = (EditMessageSettingForm)((Object)context.getForm());
        String setting = form.getSetting();
        StringUtils.trimToNull((String)form.getValue());
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        if (form.isHasGeneral()) {
            boolean isHtml = setting.toLowerCase().endsWith("html");
            String value = isHtml ? HtmlConverter.instance().valueOf(form.getValue()) : StringTrimmerConverter.instance().valueOf(form.getValue());
            PropertyHelper.set(messageSettings, setting, value);
        }
        if (form.isHasSubject()) {
            PropertyHelper.set(messageSettings, setting + "Subject", StringTrimmerConverter.instance().valueOf(form.getSubject()));
        }
        if (form.isHasBody()) {
            PropertyHelper.set(messageSettings, setting + "Message", HtmlConverter.instance().valueOf(form.getBody()));
        }
        if (form.isHasSms()) {
            PropertyHelper.set(messageSettings, setting + "Sms", StringTrimmerConverter.instance().valueOf(form.getSms()));
        }
        this.settingsService.save(messageSettings);
        context.sendMessage("settings.message.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "setting", setting);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        String value;
        String property;
        HttpServletRequest request = context.getRequest();
        EditMessageSettingForm form = (EditMessageSettingForm)((Object)context.getForm());
        MessageSettings messageSettings = this.settingsService.getMessageSettings();
        String setting = StringUtils.trimToNull((String)form.getSetting());
        if (setting == null) {
            throw new ValidationException();
        }
        try {
            String value2 = (String)PropertyHelper.get(messageSettings, setting);
            form.setValue(value2);
            form.setHasGeneral(true);
            request.setAttribute("generalIsHtml", (Object)setting.toLowerCase().endsWith("html"));
        }
        catch (PropertyException e) {
            // empty catch block
        }
        try {
            property = setting + "Subject";
            value = (String)PropertyHelper.get(messageSettings, property);
            form.setSubject(value);
            form.setHasSubject(true);
        }
        catch (PropertyException e) {
            // empty catch block
        }
        try {
            property = setting + "Message";
            value = (String)PropertyHelper.get(messageSettings, property);
            form.setBody(value);
            form.setHasBody(true);
        }
        catch (PropertyException e) {
            // empty catch block
        }
        try {
            property = setting + "Sms";
            value = (String)PropertyHelper.get(messageSettings, property);
            form.setSms(value);
            form.setHasSms(true);
        }
        catch (PropertyException e) {
            // empty catch block
        }
        request.setAttribute("setting", (Object)setting);
        request.setAttribute("format", (Object)TextFormat.RICH);
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditMessageSettingForm form = (EditMessageSettingForm)((Object)context.getForm());
        Validator validator = new Validator("settings.message");
        if (form.isHasGeneral()) {
            validator.property("value").required().maxLength(400);
        }
        if (form.isHasSubject()) {
            validator.property("subject").required().maxLength(400);
        }
        if (form.isHasBody()) {
            validator.property("body").required().maxLength(4000);
        }
        if (form.isHasSms()) {
            validator.property("sms").required().maxLength(256);
        }
        validator.validate((Object)form);
    }
}

