/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.settings;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.settings.ManageSettingsForm;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.Setting;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.settings.exceptions.SelectedSettingTypeNotInFileException;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;

public class ImportSettingsAction
extends BaseAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        ManageSettingsForm form = (ManageSettingsForm)((Object)context.getForm());
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        FormFile upload = form.getUpload();
        Collection<Setting.Type> types = CoercionHelper.coerceCollection(Setting.Type.class, List.class, form.getType());
        try {
            List lines = IOUtils.readLines((InputStream)upload.getInputStream(), (String)localSettings.getCharset());
            String xml = StringUtils.join(lines.iterator(), (char)'\n');
            this.settingsService.importFromXml(xml, types);
            context.sendMessage("settings.imported", new Object[0]);
        }
        catch (PermissionDeniedException e) {
            throw e;
        }
        catch (SelectedSettingTypeNotInFileException e) {
            List<Setting.Type> notImportedTypes = e.getNotImportedTypes();
            ArrayList<String> names = new ArrayList<String>();
            for (Setting.Type type : notImportedTypes) {
                names.add(context.message("settings.type." + type.name(), new Object[0]));
            }
            context.sendMessage("settings.error.selectedSettingTypeNotInFile", StringUtils.join(names.iterator(), (String)"\n"));
        }
        catch (Exception e) {
            context.sendMessage("settings.error.importing", new Object[0]);
        }
        finally {
            upload.destroy();
        }
        if (types.contains(Setting.Type.MAIL_TRANSLATION) || types.contains(Setting.Type.MESSAGE)) {
            return context.findForward("manageTranslationMessages");
        }
        return context.getSuccessForward();
    }
}

