/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.entities.settings.MessageSettings;
import org.apache.struts.action.ActionForward;

public class ListMessageSettingsAction
extends BaseAction {
    private static final List<String> GENERAL;
    private static final List<String> MEMBER_NOTIFICATIONS;
    private static final List<String> ADMIN_NOTIFICATIONS;

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        boolean editable = this.permissionService.hasPermission(AdminSystemPermission.TRANSLATION_MANAGE_NOTIFICATION);
        request.setAttribute("editable", (Object)editable);
        request.setAttribute("general", GENERAL);
        request.setAttribute("memberNotifications", MEMBER_NOTIFICATIONS);
        request.setAttribute("adminNotifications", ADMIN_NOTIFICATIONS);
        return context.getInputForward();
    }

    static {
        ArrayList<String> general = new ArrayList<String>();
        ArrayList<String> member = new ArrayList<String>();
        ArrayList<String> admin = new ArrayList<String>();
        block5: for (MessageSettings.MessageSettingsEnum messageSetting : MessageSettings.MessageSettingsEnum.values()) {
            switch (messageSetting.getCategory()) {
                case GENERAL: {
                    general.add(messageSetting.settingName());
                    continue block5;
                }
                case MEMBER: {
                    member.add(messageSetting.settingName());
                    continue block5;
                }
                case ADMIN: {
                    admin.add(messageSetting.settingName());
                    continue block5;
                }
                default: {
                    throw new IllegalAccessError("Unknown message setting category: " + (Object)((Object)messageSetting.getCategory()));
                }
            }
        }
        GENERAL = Collections.unmodifiableList(general);
        MEMBER_NOTIFICATIONS = Collections.unmodifiableList(member);
        ADMIN_NOTIFICATIONS = Collections.unmodifiableList(admin);
    }
}

