/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.webshop;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.BasePublicAction;
import nl.strohalm.cyclos.controls.webshop.WebShopHelper;
import nl.strohalm.cyclos.entities.accounts.transactions.WebShopTicket;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.TicketService;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CancelWebShopPaymentAction
extends BasePublicAction {
    private TicketService ticketService;

    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DoPaymentDTO payment = this.resolvePayment(request);
        WebShopTicket ticket = (WebShopTicket)payment.getTicket();
        try {
            ticket = this.ticketService.cancelWebShopTicket(ticket.getId(), request.getRemoteAddr());
        }
        catch (Exception e) {
            // empty catch block
        }
        return WebShopHelper.returnForward(ticket);
    }

    @Inject
    public void setTicketService(TicketService ticketService) {
        this.ticketService = ticketService;
    }

    private DoPaymentDTO resolvePayment(HttpServletRequest request) {
        DoPaymentDTO payment = WebShopHelper.getNewPayment(request.getSession());
        if (payment == null) {
            throw new ValidationException();
        }
        return payment;
    }
}

