/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.webshop;

import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BasePublicFormAction;
import nl.strohalm.cyclos.controls.webshop.ConfirmWebShopPaymentForm;
import nl.strohalm.cyclos.controls.webshop.WebShopHelper;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.WebShopTicket;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.access.AccessService;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.TicketService;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ConfirmWebShopPaymentAction
extends BasePublicFormAction {
    private AccessService accessService;
    private ChannelService channelService;
    private PaymentService paymentService;
    private TransactionFeeService transactionFeeService;
    private TransferTypeService transferTypeService;
    private TicketService ticketService;

    private static boolean doShouldValidateTransactionPassword(ShouldValidateTPParameter parameter) {
        Channel channel = parameter.channelService.loadByInternalName("webshop");
        if (channel.getCredentials() != Channel.Credentials.DEFAULT) {
            return false;
        }
        Member member = (Member)parameter.elementService.load(((Member)parameter.payment.getFrom()).getId(), Element.Relationships.USER);
        ActionContext context = new ActionContext(parameter.mapping, parameter.actionForm, parameter.request, parameter.response, member.getUser(), parameter.messageHelper);
        TransferType transferType = parameter.transferTypeService.load(parameter.payment.getTransferType().getId(), TransferType.Relationships.FROM);
        return context.isTransactionPasswordEnabled(transferType.getFrom());
    }

    static boolean shouldValidateTransactionPassword(final ShouldValidateTPParameter parameter) {
        return LoggedUser.runAsSystem(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ConfirmWebShopPaymentAction.doShouldValidateTransactionPassword(parameter);
            }
        });
    }

    @Inject
    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public void setTicketService(TicketService ticketService) {
        this.ticketService = ticketService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(final ActionMapping mapping, final ActionForm actionForm, final HttpServletRequest request, final HttpServletResponse response) {
        final ConfirmWebShopPaymentForm form = (ConfirmWebShopPaymentForm)actionForm;
        final DoPaymentDTO paymentDTO = this.resolvePayment(request);
        Member from = (Member)paymentDTO.getFrom();
        final HttpSession session = request.getSession();
        session.setAttribute("errorReturnTo", (Object)"/do/webshop/confirmPayment");
        return LoggedUser.runAs(from.getUser(), request.getRemoteAddr(), new Callable<ActionForward>(){

            @Override
            public ActionForward call() throws Exception {
                try {
                    if (ConfirmWebShopPaymentAction.shouldValidateTransactionPassword(new ShouldValidateTPParameter(mapping, actionForm, request, response, paymentDTO, ConfirmWebShopPaymentAction.this.channelService, ConfirmWebShopPaymentAction.this.elementService, ConfirmWebShopPaymentAction.this.transferTypeService, ConfirmWebShopPaymentAction.this.messageHelper))) {
                        ConfirmWebShopPaymentAction.this.accessService.checkTransactionPassword(form.getTransactionPassword());
                    }
                }
                catch (InvalidCredentialsException e) {
                    throw new ValidationException("transactionPassword.error.invalid", new Object[0]);
                }
                catch (BlockedCredentialsException e) {
                    ConfirmWebShopPaymentAction.this.cancelTicket(request, paymentDTO);
                    throw new ValidationException("transactionPassword.error.blockedByTrials", new Object[0]);
                }
                try {
                    Payment payment = ConfirmWebShopPaymentAction.this.paymentService.doPayment(paymentDTO);
                    WebShopHelper.setPerformedPayment(session, payment);
                    return mapping.findForward("success");
                }
                catch (CreditsException e) {
                    ConfirmWebShopPaymentAction.this.cancelTicket(request, paymentDTO);
                    throw new ValidationException(ConfirmWebShopPaymentAction.this.actionHelper.resolveErrorKey(e), ConfirmWebShopPaymentAction.this.actionHelper.resolveParameters(e));
                }
                catch (UnexpectedEntityException e) {
                    ConfirmWebShopPaymentAction.this.cancelTicket(request, paymentDTO);
                    throw new ValidationException("payment.error.invalidTransferType", new Object[0]);
                }
            }
        });
    }

    @Override
    protected void prepareForm(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        final DoPaymentDTO payment = this.resolvePayment(request);
        request.setAttribute("payment", (Object)payment);
        request.setAttribute("requestTransactionPassword", (Object)ConfirmWebShopPaymentAction.shouldValidateTransactionPassword(new ShouldValidateTPParameter(mapping, actionForm, request, response, payment, this.channelService, this.elementService, this.transferTypeService, this.messageHelper)));
        TransactionFeePreviewDTO fees = LoggedUser.runAsSystem(new Callable<TransactionFeePreviewDTO>(){

            @Override
            public TransactionFeePreviewDTO call() throws Exception {
                return ConfirmWebShopPaymentAction.this.transactionFeeService.preview(payment.getFrom(), payment.getTo(), payment.getTransferType(), payment.getAmount());
            }
        });
        request.setAttribute("finalAmount", (Object)fees.getFinalAmount());
        request.setAttribute("fees", fees.getFees());
    }

    @Override
    protected void validateForm(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws ValidationException {
        ConfirmWebShopPaymentForm form;
        DoPaymentDTO payment = this.resolvePayment(request);
        if (ConfirmWebShopPaymentAction.shouldValidateTransactionPassword(new ShouldValidateTPParameter(mapping, actionForm, request, response, payment, this.channelService, this.elementService, this.transferTypeService, this.messageHelper)) && StringUtils.isEmpty((String)(form = (ConfirmWebShopPaymentForm)actionForm).getTransactionPassword())) {
            throw new ValidationException("_transactionPassword", "login.transactionPassword", new RequiredError(new Object[0]));
        }
    }

    private void cancelTicket(HttpServletRequest request, DoPaymentDTO payment) {
        WebShopTicket ticket = this.ticketService.cancelWebShopTicket(payment.getTicket().getId(), request.getRemoteAddr());
        HttpSession session = request.getSession();
        session.removeAttribute("forceBack");
        session.setAttribute("errorReturnTo", (Object)ticket.getReturnUrl());
    }

    private DoPaymentDTO resolvePayment(HttpServletRequest request) {
        DoPaymentDTO payment = WebShopHelper.getUpdatedPayment(request.getSession());
        if (payment == null) {
            throw new ValidationException();
        }
        if (StringUtils.isEmpty((String)payment.getDescription())) {
            payment.setDescription(payment.getTransferType().getDescription());
        }
        return payment;
    }

    public static class ShouldValidateTPParameter {
        public final ActionMapping mapping;
        public final ActionForm actionForm;
        public final HttpServletRequest request;
        public final HttpServletResponse response;
        public final DoPaymentDTO payment;
        public final ChannelService channelService;
        public final ElementService elementService;
        public final TransferTypeService transferTypeService;
        public final MessageHelper messageHelper;

        public ShouldValidateTPParameter(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, DoPaymentDTO payment, ChannelService channelService, ElementService elementService, TransferTypeService transferTypeService, MessageHelper messageHelper) {
            this.mapping = mapping;
            this.actionForm = actionForm;
            this.request = request;
            this.response = response;
            this.payment = payment;
            this.channelService = channelService;
            this.elementService = elementService;
            this.transferTypeService = transferTypeService;
            this.messageHelper = messageHelper;
        }
    }
}

