/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.webshop;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.BasePublicAction;
import nl.strohalm.cyclos.controls.webshop.NewWebShopPaymentForm;
import nl.strohalm.cyclos.controls.webshop.WebShopHelper;
import nl.strohalm.cyclos.entities.accounts.transactions.Ticket;
import nl.strohalm.cyclos.entities.accounts.transactions.WebShopTicket;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.TicketService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class NewWebShopPaymentAction
extends BasePublicAction {
    private TicketService ticketService;

    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        WebShopTicket ticket;
        NewWebShopPaymentForm form = (NewWebShopPaymentForm)actionForm;
        String ticketStr = form.getTicket();
        try {
            WebShopTicket loaded;
            ticket = loaded = this.ticketService.loadPendingWebShopTicket(ticketStr, request.getRemoteAddr(), Ticket.Relationships.CURRENCY, Ticket.Relationships.TO);
        }
        catch (EntityNotFoundException e) {
            throw new ValidationException("webshop.error.ticket", new Object[0]);
        }
        DoPaymentDTO payment = new DoPaymentDTO();
        payment.setChannel("webshop");
        payment.setContext(TransactionContext.PAYMENT);
        payment.setTo(ticket.getTo());
        payment.setTicket(ticket);
        payment.setAmount(ticket.getAmount());
        payment.setCurrency(ticket.getCurrency());
        payment.setDescription(ticket.getDescription());
        HttpSession session = request.getSession();
        WebShopHelper.setNewPayment(session, payment);
        session.setAttribute("errorReturnTo", (Object)WebShopHelper.returnForward(ticket).getPath());
        session.setAttribute("isWebShop", (Object)true);
        session.setAttribute("isPosWeb", (Object)false);
        return mapping.findForward("success");
    }

    @Inject
    public void setTicketService(TicketService ticketService) {
        this.ticketService = ticketService;
    }
}

