/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.webshop;

import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.WebShopTicket;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import org.apache.struts.action.ActionForward;

public class WebShopHelper {
    private static final String PERFORMED_PAYMENT_KEY = "webshopPerformedPayment";
    private static final String NEW_PAYMENT_KEY = "webshopNewPayment";
    private static final String UPDATED_PAYMENT_KEY = "webshopUpdatedPayment";

    public static DoPaymentDTO getNewPayment(HttpSession session) {
        return (DoPaymentDTO)session.getAttribute(NEW_PAYMENT_KEY);
    }

    public static Payment getPerformedPayment(HttpSession session) {
        return (Payment)session.getAttribute(PERFORMED_PAYMENT_KEY);
    }

    public static DoPaymentDTO getUpdatedPayment(HttpSession session) {
        return (DoPaymentDTO)session.getAttribute(UPDATED_PAYMENT_KEY);
    }

    public static ActionForward returnForward(WebShopTicket ticket) {
        String url = ticket.getReturnUrl();
        String separator = url.contains("?") ? "&" : "?";
        String fullUrl = url + separator + "ticket=" + ticket.getTicket();
        return new ActionForward(fullUrl, true);
    }

    public static void setNewPayment(HttpSession session, DoPaymentDTO payment) {
        session.setAttribute(NEW_PAYMENT_KEY, (Object)payment);
    }

    public static void setPerformedPayment(HttpSession session, Payment payment) {
        session.setAttribute(PERFORMED_PAYMENT_KEY, (Object)payment);
    }

    public static void setUpdatedPayment(HttpSession session, DoPaymentDTO payment) {
        session.setAttribute(UPDATED_PAYMENT_KEY, (Object)payment);
    }
}

