/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.webshop;

import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.BasePublicFormAction;
import nl.strohalm.cyclos.controls.webshop.ConfirmWebShopPaymentAction;
import nl.strohalm.cyclos.controls.webshop.WebShopHelper;
import nl.strohalm.cyclos.controls.webshop.WebShopPaymentForm;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.WebShopTicket;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.services.access.AccessService;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.LoginException;
import nl.strohalm.cyclos.services.access.exceptions.UserNotFoundException;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.TicketService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class WebShopPaymentAction
extends BasePublicFormAction {
    private ChannelService channelService;
    private AccessService accessService;
    private TransferTypeService transferTypeService;
    private TicketService ticketService;

    @Inject
    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Inject
    public void setTicketService(TicketService ticketService) {
        this.ticketService = ticketService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(final ActionMapping mapping, final ActionForm actionForm, final HttpServletRequest request, final HttpServletResponse response) {
        return LoggedUser.runAsSystem(new Callable<ActionForward>(){

            @Override
            public ActionForward call() throws Exception {
                return WebShopPaymentAction.this.doHandleSubmit(mapping, actionForm, request, response);
            }
        });
    }

    @Override
    protected void prepareForm(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        boolean useVirtualKeyboard;
        WebShopHelper.setUpdatedPayment(request.getSession(), null);
        WebShopPaymentForm form = (WebShopPaymentForm)actionForm;
        DoPaymentDTO payment = this.resolvePayment(request);
        request.setAttribute("payment", (Object)payment);
        Channel.Credentials credentials = this.getLoginCredentials();
        request.setAttribute("credentials", (Object)credentials);
        String credentialsString = this.messageHelper.message("channel.credentials." + credentials, new Object[0]).toLowerCase();
        request.setAttribute("credentialsString", (Object)credentialsString);
        Channel channel = this.channelService.loadByInternalName("webshop");
        TreeMap<String, PrincipalType> principalTypes = new TreeMap<String, PrincipalType>();
        PrincipalType selectedPrincipalType = this.channelService.resolvePrincipalType(channel.getInternalName(), form.getPrincipalType());
        form.setPrincipalType(selectedPrincipalType.toString());
        for (PrincipalType principalType : channel.getPrincipalTypes()) {
            principalTypes.put(this.principalTypeLabel(principalType), principalType);
        }
        request.setAttribute("principalTypes", principalTypes);
        request.setAttribute("selectedPrincipalType", (Object)selectedPrincipalType);
        request.setAttribute("selectedPrincipalLabel", (Object)this.principalTypeLabel(selectedPrincipalType));
        AccessSettings accessSettings = this.settingsService.getAccessSettings();
        String virtualKeyboardChars = null;
        if (credentials == Channel.Credentials.TRANSACTION_PASSWORD) {
            useVirtualKeyboard = accessSettings.isVirtualKeyboardTransactionPassword();
            if (useVirtualKeyboard) {
                virtualKeyboardChars = accessSettings.getTransactionPasswordChars();
            }
        } else {
            useVirtualKeyboard = accessSettings.isVirtualKeyboard();
            if (useVirtualKeyboard && (accessSettings.isNumericPassword() || credentials == Channel.Credentials.PIN)) {
                virtualKeyboardChars = "0123456789";
            }
        }
        request.setAttribute("useVirtualKeyboard", (Object)useVirtualKeyboard);
        request.setAttribute("virtualKeyboardChars", (Object)virtualKeyboardChars);
        request.getSession().setAttribute("errorReturnTo", (Object)"/do/webshop/doPayment");
    }

    @Override
    protected void validateForm(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws ValidationException {
        WebShopPaymentForm form = (WebShopPaymentForm)actionForm;
        String principal = StringUtils.trimToNull((String)form.getPrincipal());
        if (principal == null) {
            PrincipalType principalType = this.channelService.resolvePrincipalType("webshop", form.getPrincipalType());
            ValidationException validationException = new ValidationException("principal", new RequiredError(new Object[0]));
            Channel.Principal principalEnum = principalType.getPrincipal();
            if (principalEnum == Channel.Principal.CUSTOM_FIELD) {
                validationException.setPropertyDisplayName("principal", principalType.getCustomField().getName());
            } else {
                validationException.setPropertyKey("principal", principalEnum.getKey());
            }
            throw validationException;
        }
        String credentials = StringUtils.trimToNull((String)form.getCredentials());
        if (credentials == null) {
            throw new ValidationException("credentials", "channel.credentials." + this.getLoginCredentials(), new RequiredError(new Object[0]));
        }
    }

    private void cancelTicket(HttpServletRequest request, DoPaymentDTO payment) {
        WebShopTicket ticket = this.ticketService.cancelWebShopTicket(payment.getTicket().getId(), request.getRemoteAddr());
        HttpSession session = request.getSession();
        session.removeAttribute("forceBack");
        session.setAttribute("errorReturnTo", (Object)ticket.getReturnUrl());
    }

    private MemberUser checkCredentials(HttpServletRequest request, WebShopPaymentForm form, DoPaymentDTO payment) {
        MemberUser user;
        try {
            Member member;
            String principal = form.getPrincipal();
            Channel webshop = this.channelService.loadByInternalName("webshop");
            PrincipalType principalType = this.channelService.resolvePrincipalType("webshop", form.getPrincipalType());
            try {
                member = this.elementService.loadByPrincipal(principalType, principal, Element.Relationships.USER);
            }
            catch (EntityNotFoundException e) {
                throw new UserNotFoundException(principal);
            }
            AccountOwner to = payment.getTo();
            Member toMember = (Member)(to instanceof Member ? to : null);
            user = this.accessService.checkCredentials(webshop, member.getMemberUser(), form.getCredentials(), request.getRemoteAddr(), toMember);
            if (!this.accessService.isChannelEnabledForMember("webshop", user.getMember())) {
                this.cancelTicket(request, payment);
                throw new ValidationException("webshop.error.paymentDisabled", new Object[0]);
            }
        }
        catch (BlockedCredentialsException e) {
            String key;
            switch (e.getCredentialsType()) {
                case TRANSACTION_PASSWORD: {
                    key = "transactionPassword.error.blockedByTrials";
                    break;
                }
                case PIN: {
                    key = "pin.error.blocked";
                    break;
                }
                default: {
                    key = "login.error.blocked";
                }
            }
            throw new ValidationException(key, new Object[0]);
        }
        catch (LoginException e) {
            throw new ValidationException("login.error", new Object[0]);
        }
        return user;
    }

    private ActionForward doHandleSubmit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        WebShopPaymentForm form = (WebShopPaymentForm)actionForm;
        DoPaymentDTO payment = (DoPaymentDTO)this.resolvePayment(request).clone();
        MemberUser user = this.checkCredentials(request, form, payment);
        payment.setFrom(user.getMember());
        TransferTypeQuery query = new TransferTypeQuery();
        query.setContext(TransactionContext.PAYMENT);
        query.setChannel("webshop");
        query.setCurrency(payment.getCurrency());
        query.setFromOwner(payment.getFrom());
        query.setToOwner(payment.getTo());
        query.setUsePriority(true);
        query.setUniqueResult();
        List<TransferType> transferTypes = this.transferTypeService.search(query);
        if (CollectionUtils.isEmpty(transferTypes)) {
            throw new ValidationException("payment.error.noTransferType", new Object[0]);
        }
        payment.setTransferType(transferTypes.iterator().next());
        WebShopHelper.setUpdatedPayment(request.getSession(), payment);
        ConfirmWebShopPaymentAction.ShouldValidateTPParameter params = new ConfirmWebShopPaymentAction.ShouldValidateTPParameter(mapping, actionForm, request, response, payment, this.channelService, this.elementService, this.transferTypeService, this.messageHelper);
        if (ConfirmWebShopPaymentAction.shouldValidateTransactionPassword(params) && user.getTransactionPasswordStatus() != User.TransactionPasswordStatus.ACTIVE) {
            this.cancelTicket(request, payment);
            throw new ValidationException("transactionPassword.error.pending", new Object[0]);
        }
        return mapping.findForward("success");
    }

    private Channel.Credentials getLoginCredentials() {
        Channel.Credentials credentials = this.getWebShopChannel().getCredentials();
        if (credentials == Channel.Credentials.DEFAULT) {
            credentials = Channel.Credentials.LOGIN_PASSWORD;
        }
        return credentials;
    }

    private Channel getWebShopChannel() {
        return this.channelService.loadByInternalName("webshop");
    }

    private String principalTypeLabel(PrincipalType principalType) {
        Channel.Principal principal = principalType.getPrincipal();
        String label = principal == Channel.Principal.CUSTOM_FIELD ? principalType.getCustomField().getName() : this.messageHelper.message(principal.getKey(), new Object[0]);
        return label;
    }

    private DoPaymentDTO resolvePayment(HttpServletRequest request) {
        DoPaymentDTO payment = WebShopHelper.getNewPayment(request.getSession());
        if (payment == null) {
            throw new ValidationException();
        }
        return payment;
    }
}

