/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao;

import java.sql.Connection;
import java.sql.SQLException;
import nl.strohalm.cyclos.dao.ApplicationDAO;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.entities.Application;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.engine.SessionFactoryImplementor;
import org.springframework.orm.hibernate3.HibernateCallback;

public class ApplicationDAOImpl
extends BaseDAOImpl<Application>
implements ApplicationDAO {
    private static final Log LOG = LogFactory.getLog(ApplicationDAOImpl.class);

    public ApplicationDAOImpl() {
        super(Application.class);
    }

    @Override
    public Application read() {
        return (Application)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Application>(){

            public Application doInHibernate(Session session) throws HibernateException, SQLException {
                return (Application)session.createCriteria(Application.class).uniqueResult();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownDBIfNeeded() {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.getSessionFactory();
        ConnectionProvider connectionProvider = sessionFactory.getConnectionProvider();
        try {
            Connection connection = connectionProvider.getConnection();
            try {
                String dbName = connection.getMetaData().getDatabaseProductName();
                if (dbName.startsWith("HSQL")) {
                    new JDBCWrapper(connection).execute("SHUTDOWN", new Object[0]);
                    LOG.info((Object)"Shutdown on HSQL Database was successful");
                }
            }
            finally {
                connectionProvider.closeConnection(connection);
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)"Error shutting down database connection", (Throwable)e);
        }
    }
}

