/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao;

import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAO;
import nl.strohalm.cyclos.dao.DeletableDAO;
import nl.strohalm.cyclos.dao.FetchDAO;
import nl.strohalm.cyclos.dao.InsertableDAO;
import nl.strohalm.cyclos.dao.JDBCCallback;
import nl.strohalm.cyclos.dao.UpdatableDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.exceptions.ApplicationException;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.hibernate.HibernateHelper;
import nl.strohalm.cyclos.utils.hibernate.HibernateQueryHandler;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import org.apache.commons.lang.ArrayUtils;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.jdbc.Work;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class BaseDAOImpl<E extends Entity>
extends HibernateDaoSupport
implements BaseDAO<E>,
InsertableDAO<E>,
UpdatableDAO<E>,
DeletableDAO<E> {
    private FetchDAO fetchDao;
    private HibernateQueryHandler hibernateQueryHandler;
    private boolean hasCache;
    protected Class<E> entityClass;
    private String queryCacheRegion;

    public BaseDAOImpl(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public Blob createBlob(final InputStream stream, final int length) {
        return (Blob)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Blob>(){

            public Blob doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getLobHelper().createBlob(stream, (long)length);
            }
        });
    }

    @Override
    public int delete(boolean flush, Long ... ids) {
        try {
            if (ids != null && ids.length > 0) {
                int count = 0;
                for (Long id : ids) {
                    Object element = this.getHibernateTemplate().get(this.getEntityType(), (Serializable)id);
                    if (element == null) continue;
                    this.getHibernateTemplate().delete(element);
                    ++count;
                }
                if (count > 0 && flush) {
                    this.flush();
                }
                this.evictSecondLevelCache();
                return count;
            }
            return 0;
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    @Override
    public final int delete(Long ... ids) throws DaoException {
        return this.delete(true, ids);
    }

    @Override
    public <T extends E> T duplicate(T entity) {
        if (entity == null) {
            return null;
        }
        Entity duplicate = (Entity)ClassHelper.instantiate(entity.getClass());
        this.hibernateQueryHandler.copyProperties((Entity)entity, duplicate);
        return (T)duplicate;
    }

    @Override
    public Class<E> getEntityType() {
        return this.entityClass;
    }

    public FetchDAO getFetchDao() {
        return this.fetchDao;
    }

    public HibernateQueryHandler getHibernateQueryHandler() {
        return this.hibernateQueryHandler;
    }

    @Override
    public final <T extends E> T insert(T entity) throws UnexpectedEntityException, DaoException {
        return this.insert(entity, true);
    }

    @Override
    public <T extends E> T insert(T entity, boolean flush) {
        try {
            if (entity == null || ((Entity)entity).isPersistent()) {
                throw new UnexpectedEntityException();
            }
            this.hibernateQueryHandler.resolveReferences((Entity)entity);
            this.getHibernateTemplate().save(entity);
            if (flush) {
                this.flush();
            }
            this.evictSecondLevelCache();
            return entity;
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    @Override
    public <T extends E> Collection<T> load(Collection<Long> ids, Relationship ... fetch) {
        if (ids == null) {
            return null;
        }
        ArrayList<T> toReturn = new ArrayList<T>();
        for (Long id : ids) {
            T entity = this.load(id, fetch);
            toReturn.add(entity);
        }
        return toReturn;
    }

    @Override
    public <T extends E> T load(Long id, Relationship ... fetch) {
        if (id == null) {
            throw new EntityNotFoundException(this.getEntityType());
        }
        try {
            Entity entity = null;
            if (!this.hasCache && !ArrayUtils.isEmpty((Object[])fetch)) {
                HashMap<String, Object> namedParams = new HashMap<String, Object>();
                StringBuilder hql = HibernateHelper.getInitialQuery(this.getEntityType(), "e", Arrays.asList(fetch));
                HibernateHelper.addParameterToQuery(hql, namedParams, "e.id", id);
                List<T> list = this.list(QueryParameters.ResultType.LIST, hql.toString(), namedParams, PageParameters.unique(), fetch);
                if (list.isEmpty()) {
                    throw new EntityNotFoundException(this.getEntityType(), id);
                }
                entity = (Entity)list.iterator().next();
            } else {
                try {
                    entity = (Entity)this.getHibernateTemplate().load(this.getEntityType(), (Serializable)id);
                }
                catch (ObjectNotFoundException e) {
                    throw new EntityNotFoundException(this.getEntityType(), id);
                }
            }
            return (T)this.fetchDao.fetch(entity, fetch);
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (ObjectNotFoundException e) {
            throw new EntityNotFoundException(this.getEntityType(), id);
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    @Override
    public <T extends E> T reload(Long id, Relationship ... fetch) {
        if (id == null) {
            return null;
        }
        E entity = EntityHelper.reference(this.getEntityType(), id);
        return (T)this.fetchDao.reload(entity, fetch);
    }

    public final void setFetchDao(FetchDAO fetchDao) {
        this.fetchDao = fetchDao;
    }

    public void setHibernateQueryHandler(HibernateQueryHandler hibernateQueryHandler) {
        this.hibernateQueryHandler = hibernateQueryHandler;
    }

    @Override
    public final <T extends E> T update(T entity) throws DaoException {
        return this.update(entity, true);
    }

    @Override
    public <T extends E> T update(T entity, boolean flush) {
        if (entity == null || ((Entity)entity).isTransient()) {
            throw new UnexpectedEntityException();
        }
        try {
            this.hibernateQueryHandler.resolveReferences((Entity)entity);
            Entity ret = (Entity)this.getHibernateTemplate().execute(new HibernateCallback<T>((Entity)entity){
                final /* synthetic */ Entity val$entity;
                {
                    this.val$entity = entity;
                }

                public T doInHibernate(Session session) throws HibernateException, SQLException {
                    try {
                        session.update((Object)this.val$entity);
                        return this.val$entity;
                    }
                    catch (NonUniqueObjectException e) {
                        session.merge((Object)this.val$entity);
                        Entity current = (Entity)session.load(EntityHelper.getRealClass(this.val$entity), (Serializable)this.val$entity.getId());
                        return current;
                    }
                }
            });
            if (flush) {
                this.flush();
            }
            this.evictSecondLevelCache();
            return (T)ret;
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    protected int bulkUpdate(final String hql, final Object namedParameters) {
        try {
            return (Integer)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Integer>(){

                public Integer doInHibernate(Session session) throws HibernateException, SQLException {
                    Query query = session.createQuery(hql);
                    BaseDAOImpl.this.hibernateQueryHandler.setQueryParameters(query, namedParameters);
                    int rows = query.executeUpdate();
                    if (rows > 0) {
                        CurrentTransactionData.setWrite();
                    }
                    return rows;
                }
            });
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    protected HibernateTemplate createHibernateTemplate(SessionFactory sessionFactory) {
        SessionFactoryImplementor sf = (SessionFactoryImplementor)sessionFactory;
        this.hasCache = sf.getEntityPersister(this.getEntityType().getName()).hasCache();
        if (this.shouldUseQueryCache()) {
            this.queryCacheRegion = "query." + this.getClass().getSimpleName();
        }
        return super.createHibernateTemplate(sessionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evictSecondLevelCache() {
        Cache cache;
        SessionFactory sessionFactory;
        SessionFactory sessionFactory2 = this.getSessionFactory();
        if (this.hasCache) {
            sessionFactory = sessionFactory2;
            synchronized (sessionFactory) {
                cache = sessionFactory2.getCache();
                cache.evictCollectionRegions();
            }
        }
        if (this.queryCacheRegion != null) {
            sessionFactory = sessionFactory2;
            synchronized (sessionFactory) {
                cache = sessionFactory2.getCache();
                cache.evictQueryRegion(this.queryCacheRegion);
            }
        }
    }

    protected void flush() {
        this.getHibernateTemplate().flush();
    }

    protected <T> Iterator<T> iterate(String hql, Object namedParameters) {
        try {
            return this.hibernateQueryHandler.simpleIterator(hql, namedParameters, null);
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    protected <T> List<T> list(QueryParameters query, String hql) {
        return this.list(query, hql, query);
    }

    protected <T> List<T> list(QueryParameters query, String hql, Object namedParameters) {
        return this.list(query.getResultType(), hql, namedParameters, query.getPageParameters(), this.fetchArray(query));
    }

    protected <T> List<T> list(QueryParameters.ResultType resultType, String hql, Object namedParameters, PageParameters pageParameters, Relationship ... fetch) {
        try {
            return this.hibernateQueryHandler.executeQuery(this.queryCacheRegion, resultType, hql, namedParameters, pageParameters, fetch);
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    protected <T> List<T> list(final String hql, final Object namedParameters) {
        try {
            return this.getHibernateTemplate().executeFind(new HibernateCallback<List<T>>(){

                public List<T> doInHibernate(Session session) throws HibernateException, SQLException {
                    Query query = session.createQuery(hql);
                    BaseDAOImpl.this.process(query, namedParameters);
                    return query.list();
                }
            });
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K, V> Map<K, V> map(String hql, Object namedParameters) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        Iterator iterator = this.iterate(hql, namedParameters);
        try {
            while (iterator.hasNext()) {
                Object[] row = (Object[])iterator.next();
                map.put(row[0], row[1]);
            }
        }
        finally {
            DataIteratorHelper.close(iterator);
        }
        return map;
    }

    protected void runNative(final JDBCCallback callback) {
        this.getSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                callback.execute(new JDBCWrapper(connection));
            }
        });
        CurrentTransactionData.setWrite();
    }

    protected boolean shouldUseQueryCache() {
        return this.hasCache;
    }

    protected <T> T uniqueResult(final String hql, final Object namedParameters) {
        try {
            return (T)this.getHibernateTemplate().execute(new HibernateCallback<T>(){

                public T doInHibernate(Session session) throws HibernateException, SQLException {
                    Query query = session.createQuery(hql);
                    BaseDAOImpl.this.process(query, namedParameters);
                    query.setMaxResults(1);
                    return query.uniqueResult();
                }
            });
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    private Relationship[] fetchArray(QueryParameters query) {
        Relationship[] fetch = query.getFetch() == null || query.getFetch().isEmpty() ? new Relationship[]{} : query.getFetch().toArray(new Relationship[query.getFetch().size()]);
        return fetch;
    }

    private void process(Query query, Object namedParameters) {
        this.hibernateQueryHandler.setQueryParameters(query, namedParameters);
        if (this.queryCacheRegion != null) {
            query.setCacheable(true);
            query.setCacheRegion(this.queryCacheRegion);
        }
    }
}

