/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao;

import java.io.Serializable;
import nl.strohalm.cyclos.dao.FetchDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.binding.PropertyException;
import nl.strohalm.cyclos.utils.hibernate.HibernateQueryHandler;
import org.apache.commons.lang.ArrayUtils;
import org.hibernate.Hibernate;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class FetchDAOImpl
extends HibernateDaoSupport
implements FetchDAO {
    private HibernateQueryHandler hibernateQueryHandler;

    @Override
    public void clearCache() {
        HibernateTemplate ht = this.getHibernateTemplate();
        ht.flush();
        ht.clear();
    }

    @Override
    public <E extends Entity> E fetch(E inputEntity, Relationship ... fetch) {
        return this.doFetch(inputEntity, fetch);
    }

    @Override
    public boolean isInitialized(Object value) {
        return !(value instanceof HibernateProxy) && Hibernate.isInitialized((Object)value);
    }

    @Override
    public <E extends Entity> E reload(E entity, Relationship ... fetch) throws UnexpectedEntityException, EntityNotFoundException, DaoException {
        if (entity == null || entity.getId() == null) {
            throw new UnexpectedEntityException();
        }
        HibernateTemplate ht = this.getHibernateTemplate();
        Entity current = (Entity)ht.load(EntityHelper.getRealClass(entity), (Serializable)entity.getId());
        ht.refresh((Object)current);
        return (E)this.doFetch(current, fetch);
    }

    @Override
    public void removeFromCache(Entity entity) {
        this.getHibernateTemplate().evict((Object)entity);
    }

    public void setHibernateQueryHandler(HibernateQueryHandler hibernateQueryHandler) {
        this.hibernateQueryHandler = hibernateQueryHandler;
    }

    private <E extends Entity> E doFetch(E inputEntity, Relationship ... fetch) {
        Entity entity;
        if (inputEntity == null || inputEntity.getId() == null) {
            throw new UnexpectedEntityException();
        }
        Class<? extends Entity> entityType = EntityHelper.getRealClass(inputEntity);
        Long id = inputEntity.getId();
        try {
            entity = (Entity)this.getHibernateTemplate().load(entityType, (Serializable)id);
            entity = (Entity)this.hibernateQueryHandler.initialize(entity);
        }
        catch (ObjectRetrievalFailureException e) {
            throw new EntityNotFoundException(entityType, id);
        }
        catch (ObjectNotFoundException e) {
            throw new EntityNotFoundException(entityType, id);
        }
        if (!ArrayUtils.isEmpty((Object[])fetch)) {
            for (Relationship relationship : fetch) {
                if (relationship == null) continue;
                try {
                    String name = relationship.getName();
                    Object bean = entity;
                    String first = PropertyHelper.firstProperty(name);
                    String nested = PropertyHelper.nestedPath(name);
                    while (bean != null && first != null) {
                        Object value;
                        bean = value = this.hibernateQueryHandler.initializeProperty(bean, first);
                        first = PropertyHelper.firstProperty(nested);
                        nested = PropertyHelper.nestedPath(nested);
                    }
                }
                catch (PropertyException e) {
                }
                catch (Exception e) {
                    throw new PropertyException(entity, relationship.getName(), e);
                }
            }
        }
        return (E)entity;
    }
}

