/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao;

import java.util.Arrays;
import java.util.List;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.IndexedDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.lucene.Filters;
import nl.strohalm.cyclos.utils.lucene.IndexHandler;
import nl.strohalm.cyclos.utils.lucene.LuceneQueryHandler;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public abstract class IndexedDAOImpl<E extends Entity>
extends BaseDAOImpl<E>
implements IndexedDAO<E> {
    protected IndexHandler indexHandler;
    protected LuceneQueryHandler luceneQueryHandler;

    public IndexedDAOImpl(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    public void addToIndex(E entity) {
        Class<? extends Entity> type = EntityHelper.getRealClass(entity);
        this.indexHandler.index(type, ((Entity)entity).getId());
    }

    @Override
    public void removeFromIndex(Class<? extends E> entityType, Long ... ids) {
        if (ids != null && ids.length > 0) {
            this.indexHandler.remove(entityType, Arrays.asList(ids));
        }
    }

    @Override
    public void removeFromIndex(E entity) {
        Class<? extends Entity> type = EntityHelper.getRealClass(entity);
        this.indexHandler.remove(type, ((Entity)entity).getId());
    }

    public void setIndexHandler(IndexHandler indexHandler) {
        this.indexHandler = indexHandler;
    }

    public void setLuceneQueryHandler(LuceneQueryHandler luceneQueryHandler) {
        this.luceneQueryHandler = luceneQueryHandler;
    }

    protected void addCustomField(Filters filters, Analyzer analyzer, CustomFieldValue fieldValue) {
        this.addCustomField(filters, analyzer, fieldValue, "customValues.%s");
    }

    protected void addCustomField(Filters filters, Analyzer analyzer, CustomFieldValue fieldValue, String fieldNamePattern) {
        CustomField field = fieldValue.getField();
        if (field == null) {
            return;
        }
        field = this.getFetchDao().fetch(field, new Relationship[0]);
        String value = fieldValue.getValue();
        if (field.getType() == CustomField.Type.ENUMERATED && fieldValue.getPossibleValue() != null) {
            value = fieldValue.getPossibleValue().getId().toString();
        } else if (field.getType() == CustomField.Type.MEMBER && fieldValue.getMemberValue() != null) {
            value = fieldValue.getMemberValue().getId().toString();
        }
        if (StringUtils.isNotEmpty((String)field.getPattern())) {
            value = StringHelper.removeMask(field.getPattern(), value, false);
        }
        if (StringUtils.isNotEmpty((String)value)) {
            String fieldName = String.format(fieldNamePattern, field.getId());
            switch (field.getType()) {
                case ENUMERATED: {
                    String[] values = StringUtils.split((String)value, (char)',');
                    filters.addTerms(fieldName, values);
                    break;
                }
                case STRING: 
                case URL: {
                    filters.addFieldQuery(analyzer, fieldName, value);
                    break;
                }
                default: {
                    filters.addTerms(fieldName, value);
                }
            }
        }
    }

    protected <T extends E> List<T> list(Class<T> entityType, QueryParameters queryParameters, Query query, Filters filters, Sort sort) {
        QueryParameters.ResultType resultType = queryParameters == null || queryParameters.getResultType() == null ? QueryParameters.ResultType.LIST : queryParameters.getResultType();
        PageParameters pageParameters = queryParameters == null ? null : queryParameters.getPageParameters();
        Relationship[] fetch = queryParameters == null || queryParameters.getFetch() == null ? null : queryParameters.getFetch().toArray(new Relationship[queryParameters.getFetch().size()]);
        return this.luceneQueryHandler.executeQuery(entityType, query, filters, sort, resultType, pageParameters, fetch);
    }
}

