/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.dao.access;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import nl.strohalm.cyclos.dao.BaseDAOImpl;
import nl.strohalm.cyclos.dao.access.ChannelDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.setup.CreateBasicData;
import nl.strohalm.cyclos.setup.Setup;

public class ChannelDAOImpl
extends BaseDAOImpl<Channel>
implements ChannelDAO {
    public ChannelDAOImpl() {
        super(Channel.class);
    }

    @Override
    public boolean existsChannel(String internalName) {
        try {
            this.loadByInternalName(internalName, new Relationship[0]);
            return true;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    @Override
    public void importNewBuiltin(Locale locale) {
        CreateBasicData.createChannels(this.getSession(), Setup.getResourceBundle(locale));
    }

    @Override
    public List<Channel> listAll(Relationship ... fetch) {
        List<Channel> channels = this.list("from Channel c order by c.displayName", null);
        for (int i = 0; i < channels.size(); ++i) {
            channels.set(i, (Channel)this.getFetchDao().fetch((Entity)channels.get(i), fetch));
        }
        return channels;
    }

    @Override
    public Channel loadByInternalName(String name, Relationship ... fetch) throws EntityNotFoundException {
        Map<String, String> params = Collections.singletonMap("name", name);
        Channel channel = (Channel)this.uniqueResult("from Channel c where c.internalName = :name", params);
        if (channel == null) {
            throw new EntityNotFoundException(Channel.class);
        }
        return this.getFetchDao().fetch(channel, fetch);
    }
}

